/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.typesense.model.AnalyticsRule;
import org.typesense.model.AnalyticsRuleCreateParams;
import org.typesense.model.AnalyticsRuleType;

public class AnalyticsRuleSerializer {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public AnalyticsRuleSerializer() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
    }

    public AnalyticsRule parseFromJsonNode(JsonNode node) {
        String typeStr;
        AnalyticsRuleType type;
        AnalyticsRule rule = new AnalyticsRule();
        if (node.has("name")) {
            rule.name(node.get("name").asText());
        }
        if (node.has("type") && (type = AnalyticsRuleType.fromValue(typeStr = node.get("type").asText())) != null) {
            rule.type(type);
        }
        if (node.has("collection")) {
            rule.collection(node.get("collection").asText());
        }
        if (node.has("event_type")) {
            rule.eventType(node.get("event_type").asText());
        }
        if (node.has("rule_tag")) {
            rule.ruleTag(node.get("rule_tag").asText());
        }
        if (node.has("params")) {
            JsonNode paramsNode = node.get("params");
            AnalyticsRuleCreateParams params = new AnalyticsRuleCreateParams();
            if (paramsNode.has("counter_field")) {
                params.counterField(paramsNode.get("counter_field").asText());
            }
            if (paramsNode.has("weight")) {
                params.weight(paramsNode.get("weight").asInt());
            }
            if (paramsNode.has("destination_collection")) {
                params.destinationCollection(paramsNode.get("destination_collection").asText());
            }
            if (paramsNode.has("limit")) {
                params.limit(paramsNode.get("limit").asInt());
            }
            if (paramsNode.has("capture_search_requests")) {
                params.captureSearchRequests(paramsNode.get("capture_search_requests").asBoolean());
            }
            if (paramsNode.has("meta_fields")) {
                ArrayList<String> metaFields = new ArrayList<String>();
                JsonNode metaFieldsNode = paramsNode.get("meta_fields");
                if (metaFieldsNode.isArray()) {
                    for (JsonNode metaField : metaFieldsNode) {
                        metaFields.add(metaField.asText());
                    }
                }
                params.metaFields(metaFields);
            }
            if (paramsNode.has("expand_query")) {
                params.expandQuery(paramsNode.get("expand_query").asBoolean());
            }
            rule.params(params);
        }
        return rule;
    }

    public AnalyticsRule parseFromJson(String jsonResponse) throws Exception {
        JsonNode rootNode = this.objectMapper.readTree(jsonResponse);
        return this.parseFromJsonNode(rootNode);
    }

    public List<AnalyticsRule> parseListFromJson(String jsonResponse) throws Exception {
        JsonNode rootNode = this.objectMapper.readTree(jsonResponse);
        ArrayList<AnalyticsRule> rules = new ArrayList<AnalyticsRule>();
        if (rootNode.isArray()) {
            for (JsonNode item : rootNode) {
                if (item.has("error")) {
                    String error = item.get("error").asText();
                    throw new RuntimeException("Analytics rule parsing failed: " + error);
                }
                AnalyticsRule rule = this.parseFromJsonNode(item);
                rules.add(rule);
            }
        } else {
            AnalyticsRule rule = this.parseFromJsonNode(rootNode);
            rules.add(rule);
        }
        return rules;
    }
}

