/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.api;

import java.util.Map;
import org.typesense.api.ApiCall;
import org.typesense.model.MultiSearchResult;
import org.typesense.model.MultiSearchSearchesParameter;
import org.typesense.model.SearchResult;

public class MultiSearch {
    private ApiCall apiCall;
    public static final String RESOURCEPATH = "/multi_search";

    public MultiSearch(ApiCall apiCall) {
        this.apiCall = apiCall;
    }

    public MultiSearchResult perform(MultiSearchSearchesParameter multiSearchParameters, Map<String, String> common_params) throws Exception {
        if (multiSearchParameters.isUnion().booleanValue()) {
            throw new IllegalArgumentException("The 'perform()' method is for non-union searches. For a union search, please use the 'performUnion()' method.");
        }
        return this.apiCall.post(RESOURCEPATH, multiSearchParameters, common_params, MultiSearchResult.class);
    }

    public SearchResult performUnion(MultiSearchSearchesParameter multiSearchParameters, Map<String, String> common_params) throws Exception {
        MultiSearchSearchesParameter copiedParams = new MultiSearchSearchesParameter();
        copiedParams.setSearches(multiSearchParameters.getSearches());
        copiedParams.setUnion(true);
        return this.apiCall.post(RESOURCEPATH, copiedParams, common_params, SearchResult.class);
    }
}

