/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.typesense.api.ApiCall;
import org.typesense.api.StemmingDictionariesRetrieveSchema;
import org.typesense.model.StemmingDictionaryWords;

public class StemmingDictionaries {
    private final ApiCall apiCall;
    public static final String RESOURCE_PATH = "/stemming/dictionaries";

    public StemmingDictionaries(ApiCall apiCall) {
        this.apiCall = apiCall;
    }

    public String upsert(String dictionaryId, String wordRootCombinations) throws Exception {
        Map<String, String> params = Collections.singletonMap("id", dictionaryId);
        return this.apiCall.post(this.getEndPoint("import"), wordRootCombinations, params, String.class);
    }

    public List<StemmingDictionaryWords> upsert(String dictionaryId, List<StemmingDictionaryWords> wordRootCombinations) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<String> jsonLines = new ArrayList<String>();
        ArrayList<StemmingDictionaryWords> objectList = new ArrayList<StemmingDictionaryWords>();
        for (StemmingDictionaryWords word : wordRootCombinations) {
            jsonLines.add(mapper.writeValueAsString((Object)word));
        }
        String reqBody = String.join((CharSequence)"\n", jsonLines);
        Map<String, String> params = Collections.singletonMap("id", dictionaryId);
        String resInJsonLineFormat = this.apiCall.post(this.getEndPoint("import"), reqBody, params, String.class);
        for (String line : resInJsonLineFormat.split("\n")) {
            objectList.add((StemmingDictionaryWords)mapper.readValue(line, StemmingDictionaryWords.class));
        }
        return objectList;
    }

    public StemmingDictionariesRetrieveSchema retrieve() throws Exception {
        StemmingDictionariesRetrieveSchema response = this.apiCall.get(RESOURCE_PATH, null, StemmingDictionariesRetrieveSchema.class);
        return response != null ? response : new StemmingDictionariesRetrieveSchema();
    }

    public String getEndPoint(String target) {
        return "/stemming/dictionaries/" + target;
    }
}

