/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.typesense.model.FieldEmbed;

public class Field {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="optional")
    private Boolean optional = null;
    @JsonProperty(value="facet")
    private Boolean facet = null;
    @JsonProperty(value="index")
    private Boolean index = true;
    @JsonProperty(value="locale")
    private String locale = null;
    @JsonProperty(value="sort")
    private Boolean sort = null;
    @JsonProperty(value="infix")
    private Boolean infix = false;
    @JsonProperty(value="reference")
    private String reference = null;
    @JsonProperty(value="async_reference")
    private Boolean asyncReference = null;
    @JsonProperty(value="num_dim")
    private Integer numDim = null;
    @JsonProperty(value="drop")
    private Boolean drop = null;
    @JsonProperty(value="store")
    private Boolean store = null;
    @JsonProperty(value="vec_dist")
    private String vecDist = null;
    @JsonProperty(value="range_index")
    private Boolean rangeIndex = null;
    @JsonProperty(value="stem")
    private Boolean stem = null;
    @JsonProperty(value="stem_dictionary")
    private String stemDictionary = null;
    @JsonProperty(value="token_separators")
    private List<String> tokenSeparators = null;
    @JsonProperty(value="symbols_to_index")
    private List<String> symbolsToIndex = null;
    @JsonProperty(value="embed")
    private FieldEmbed embed = null;

    public Field name(String name) {
        this.name = name;
        return this;
    }

    @Schema(example="company_name", required=true, description="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Field type(String type) {
        this.type = type;
        return this;
    }

    @Schema(example="string", required=true, description="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Field optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Schema(example="true", description="")
    public Boolean isOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public Field facet(Boolean facet) {
        this.facet = facet;
        return this;
    }

    @Schema(example="false", description="")
    public Boolean isFacet() {
        return this.facet;
    }

    public void setFacet(Boolean facet) {
        this.facet = facet;
    }

    public Field index(Boolean index) {
        this.index = index;
        return this;
    }

    @Schema(example="true", description="")
    public Boolean isIndex() {
        return this.index;
    }

    public void setIndex(Boolean index) {
        this.index = index;
    }

    public Field locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Schema(example="el", description="")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Field sort(Boolean sort) {
        this.sort = sort;
        return this;
    }

    @Schema(example="true", description="")
    public Boolean isSort() {
        return this.sort;
    }

    public void setSort(Boolean sort) {
        this.sort = sort;
    }

    public Field infix(Boolean infix) {
        this.infix = infix;
        return this;
    }

    @Schema(example="true", description="")
    public Boolean isInfix() {
        return this.infix;
    }

    public void setInfix(Boolean infix) {
        this.infix = infix;
    }

    public Field reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Schema(description="Name of a field in another collection that should be linked to this collection so that it can be joined during query. ")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Field asyncReference(Boolean asyncReference) {
        this.asyncReference = asyncReference;
        return this;
    }

    @Schema(description="Allow documents to be indexed successfully even when the referenced document doesn't exist yet. ")
    public Boolean isAsyncReference() {
        return this.asyncReference;
    }

    public void setAsyncReference(Boolean asyncReference) {
        this.asyncReference = asyncReference;
    }

    public Field numDim(Integer numDim) {
        this.numDim = numDim;
        return this;
    }

    @Schema(example="256", description="")
    public Integer getNumDim() {
        return this.numDim;
    }

    public void setNumDim(Integer numDim) {
        this.numDim = numDim;
    }

    public Field drop(Boolean drop) {
        this.drop = drop;
        return this;
    }

    @Schema(example="true", description="")
    public Boolean isDrop() {
        return this.drop;
    }

    public void setDrop(Boolean drop) {
        this.drop = drop;
    }

    public Field store(Boolean store) {
        this.store = store;
        return this;
    }

    @Schema(description="When set to false, the field value will not be stored on disk. Default: true. ")
    public Boolean isStore() {
        return this.store;
    }

    public void setStore(Boolean store) {
        this.store = store;
    }

    public Field vecDist(String vecDist) {
        this.vecDist = vecDist;
        return this;
    }

    @Schema(description="The distance metric to be used for vector search. Default: `cosine`. You can also use `ip` for inner product. ")
    public String getVecDist() {
        return this.vecDist;
    }

    public void setVecDist(String vecDist) {
        this.vecDist = vecDist;
    }

    public Field rangeIndex(Boolean rangeIndex) {
        this.rangeIndex = rangeIndex;
        return this;
    }

    @Schema(description="Enables an index optimized for range filtering on numerical fields (e.g. rating:>3.5). Default: false. ")
    public Boolean isRangeIndex() {
        return this.rangeIndex;
    }

    public void setRangeIndex(Boolean rangeIndex) {
        this.rangeIndex = rangeIndex;
    }

    public Field stem(Boolean stem) {
        this.stem = stem;
        return this;
    }

    @Schema(description="Values are stemmed before indexing in-memory. Default: false. ")
    public Boolean isStem() {
        return this.stem;
    }

    public void setStem(Boolean stem) {
        this.stem = stem;
    }

    public Field stemDictionary(String stemDictionary) {
        this.stemDictionary = stemDictionary;
        return this;
    }

    @Schema(example="irregular-plurals", description="Name of the stemming dictionary to use for this field")
    public String getStemDictionary() {
        return this.stemDictionary;
    }

    public void setStemDictionary(String stemDictionary) {
        this.stemDictionary = stemDictionary;
    }

    public Field tokenSeparators(List<String> tokenSeparators) {
        this.tokenSeparators = tokenSeparators;
        return this;
    }

    public Field addTokenSeparatorsItem(String tokenSeparatorsItem) {
        if (this.tokenSeparators == null) {
            this.tokenSeparators = new ArrayList<String>();
        }
        this.tokenSeparators.add(tokenSeparatorsItem);
        return this;
    }

    @Schema(description="List of symbols or special characters to be used for splitting the text into individual words in addition to space and new-line characters. ")
    public List<String> getTokenSeparators() {
        return this.tokenSeparators;
    }

    public void setTokenSeparators(List<String> tokenSeparators) {
        this.tokenSeparators = tokenSeparators;
    }

    public Field symbolsToIndex(List<String> symbolsToIndex) {
        this.symbolsToIndex = symbolsToIndex;
        return this;
    }

    public Field addSymbolsToIndexItem(String symbolsToIndexItem) {
        if (this.symbolsToIndex == null) {
            this.symbolsToIndex = new ArrayList<String>();
        }
        this.symbolsToIndex.add(symbolsToIndexItem);
        return this;
    }

    @Schema(description="List of symbols or special characters to be indexed. ")
    public List<String> getSymbolsToIndex() {
        return this.symbolsToIndex;
    }

    public void setSymbolsToIndex(List<String> symbolsToIndex) {
        this.symbolsToIndex = symbolsToIndex;
    }

    public Field embed(FieldEmbed embed) {
        this.embed = embed;
        return this;
    }

    @Schema(description="")
    public FieldEmbed getEmbed() {
        return this.embed;
    }

    public void setEmbed(FieldEmbed embed) {
        this.embed = embed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return Objects.equals(this.name, field.name) && Objects.equals(this.type, field.type) && Objects.equals(this.optional, field.optional) && Objects.equals(this.facet, field.facet) && Objects.equals(this.index, field.index) && Objects.equals(this.locale, field.locale) && Objects.equals(this.sort, field.sort) && Objects.equals(this.infix, field.infix) && Objects.equals(this.reference, field.reference) && Objects.equals(this.asyncReference, field.asyncReference) && Objects.equals(this.numDim, field.numDim) && Objects.equals(this.drop, field.drop) && Objects.equals(this.store, field.store) && Objects.equals(this.vecDist, field.vecDist) && Objects.equals(this.rangeIndex, field.rangeIndex) && Objects.equals(this.stem, field.stem) && Objects.equals(this.stemDictionary, field.stemDictionary) && Objects.equals(this.tokenSeparators, field.tokenSeparators) && Objects.equals(this.symbolsToIndex, field.symbolsToIndex) && Objects.equals(this.embed, field.embed);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.optional, this.facet, this.index, this.locale, this.sort, this.infix, this.reference, this.asyncReference, this.numDim, this.drop, this.store, this.vecDist, this.rangeIndex, this.stem, this.stemDictionary, this.tokenSeparators, this.symbolsToIndex, this.embed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Field {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    facet: ").append(this.toIndentedString(this.facet)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    infix: ").append(this.toIndentedString(this.infix)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    asyncReference: ").append(this.toIndentedString(this.asyncReference)).append("\n");
        sb.append("    numDim: ").append(this.toIndentedString(this.numDim)).append("\n");
        sb.append("    drop: ").append(this.toIndentedString(this.drop)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    vecDist: ").append(this.toIndentedString(this.vecDist)).append("\n");
        sb.append("    rangeIndex: ").append(this.toIndentedString(this.rangeIndex)).append("\n");
        sb.append("    stem: ").append(this.toIndentedString(this.stem)).append("\n");
        sb.append("    stemDictionary: ").append(this.toIndentedString(this.stemDictionary)).append("\n");
        sb.append("    tokenSeparators: ").append(this.toIndentedString(this.tokenSeparators)).append("\n");
        sb.append("    symbolsToIndex: ").append(this.toIndentedString(this.symbolsToIndex)).append("\n");
        sb.append("    embed: ").append(this.toIndentedString(this.embed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

