/*
 * Decompiled with CFR 0.152.
 */
package org.typesense.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NLSearchModelBase {
    @JsonProperty(value="model_name")
    private String modelName = null;
    @JsonProperty(value="api_key")
    private String apiKey = null;
    @JsonProperty(value="api_url")
    private String apiUrl = null;
    @JsonProperty(value="max_bytes")
    private Integer maxBytes = null;
    @JsonProperty(value="temperature")
    private BigDecimal temperature = null;
    @JsonProperty(value="system_prompt")
    private String systemPrompt = null;
    @JsonProperty(value="top_p")
    private BigDecimal topP = null;
    @JsonProperty(value="top_k")
    private Integer topK = null;
    @JsonProperty(value="stop_sequences")
    private List<String> stopSequences = null;
    @JsonProperty(value="api_version")
    private String apiVersion = null;
    @JsonProperty(value="project_id")
    private String projectId = null;
    @JsonProperty(value="access_token")
    private String accessToken = null;
    @JsonProperty(value="refresh_token")
    private String refreshToken = null;
    @JsonProperty(value="client_id")
    private String clientId = null;
    @JsonProperty(value="client_secret")
    private String clientSecret = null;
    @JsonProperty(value="region")
    private String region = null;
    @JsonProperty(value="max_output_tokens")
    private Integer maxOutputTokens = null;
    @JsonProperty(value="account_id")
    private String accountId = null;

    public NLSearchModelBase modelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Schema(description="Name of the NL model to use")
    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public NLSearchModelBase apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Schema(description="API key for the NL model service")
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public NLSearchModelBase apiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return this;
    }

    @Schema(description="Custom API URL for the NL model service")
    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public NLSearchModelBase maxBytes(Integer maxBytes) {
        this.maxBytes = maxBytes;
        return this;
    }

    @Schema(description="Maximum number of bytes to process")
    public Integer getMaxBytes() {
        return this.maxBytes;
    }

    public void setMaxBytes(Integer maxBytes) {
        this.maxBytes = maxBytes;
    }

    public NLSearchModelBase temperature(BigDecimal temperature) {
        this.temperature = temperature;
        return this;
    }

    @Schema(description="Temperature parameter for the NL model")
    public BigDecimal getTemperature() {
        return this.temperature;
    }

    public void setTemperature(BigDecimal temperature) {
        this.temperature = temperature;
    }

    public NLSearchModelBase systemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
        return this;
    }

    @Schema(description="System prompt for the NL model")
    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    public void setSystemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
    }

    public NLSearchModelBase topP(BigDecimal topP) {
        this.topP = topP;
        return this;
    }

    @Schema(description="Top-p parameter for the NL model (Google-specific)")
    public BigDecimal getTopP() {
        return this.topP;
    }

    public void setTopP(BigDecimal topP) {
        this.topP = topP;
    }

    public NLSearchModelBase topK(Integer topK) {
        this.topK = topK;
        return this;
    }

    @Schema(description="Top-k parameter for the NL model (Google-specific)")
    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public NLSearchModelBase stopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
        return this;
    }

    public NLSearchModelBase addStopSequencesItem(String stopSequencesItem) {
        if (this.stopSequences == null) {
            this.stopSequences = new ArrayList<String>();
        }
        this.stopSequences.add(stopSequencesItem);
        return this;
    }

    @Schema(description="Stop sequences for the NL model (Google-specific)")
    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public NLSearchModelBase apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Schema(description="API version for the NL model service")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public NLSearchModelBase projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @Schema(description="Project ID for GCP Vertex AI")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public NLSearchModelBase accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Schema(description="Access token for GCP Vertex AI")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public NLSearchModelBase refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Schema(description="Refresh token for GCP Vertex AI")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public NLSearchModelBase clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Schema(description="Client ID for GCP Vertex AI")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public NLSearchModelBase clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Schema(description="Client secret for GCP Vertex AI")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public NLSearchModelBase region(String region) {
        this.region = region;
        return this;
    }

    @Schema(description="Region for GCP Vertex AI")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public NLSearchModelBase maxOutputTokens(Integer maxOutputTokens) {
        this.maxOutputTokens = maxOutputTokens;
        return this;
    }

    @Schema(description="Maximum output tokens for GCP Vertex AI")
    public Integer getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    public void setMaxOutputTokens(Integer maxOutputTokens) {
        this.maxOutputTokens = maxOutputTokens;
    }

    public NLSearchModelBase accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(description="Account ID for Cloudflare-specific models")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NLSearchModelBase nlSearchModelBase = (NLSearchModelBase)o;
        return Objects.equals(this.modelName, nlSearchModelBase.modelName) && Objects.equals(this.apiKey, nlSearchModelBase.apiKey) && Objects.equals(this.apiUrl, nlSearchModelBase.apiUrl) && Objects.equals(this.maxBytes, nlSearchModelBase.maxBytes) && Objects.equals(this.temperature, nlSearchModelBase.temperature) && Objects.equals(this.systemPrompt, nlSearchModelBase.systemPrompt) && Objects.equals(this.topP, nlSearchModelBase.topP) && Objects.equals(this.topK, nlSearchModelBase.topK) && Objects.equals(this.stopSequences, nlSearchModelBase.stopSequences) && Objects.equals(this.apiVersion, nlSearchModelBase.apiVersion) && Objects.equals(this.projectId, nlSearchModelBase.projectId) && Objects.equals(this.accessToken, nlSearchModelBase.accessToken) && Objects.equals(this.refreshToken, nlSearchModelBase.refreshToken) && Objects.equals(this.clientId, nlSearchModelBase.clientId) && Objects.equals(this.clientSecret, nlSearchModelBase.clientSecret) && Objects.equals(this.region, nlSearchModelBase.region) && Objects.equals(this.maxOutputTokens, nlSearchModelBase.maxOutputTokens) && Objects.equals(this.accountId, nlSearchModelBase.accountId);
    }

    public int hashCode() {
        return Objects.hash(this.modelName, this.apiKey, this.apiUrl, this.maxBytes, this.temperature, this.systemPrompt, this.topP, this.topK, this.stopSequences, this.apiVersion, this.projectId, this.accessToken, this.refreshToken, this.clientId, this.clientSecret, this.region, this.maxOutputTokens, this.accountId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NLSearchModelBase {\n");
        sb.append("    modelName: ").append(this.toIndentedString(this.modelName)).append("\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    apiUrl: ").append(this.toIndentedString(this.apiUrl)).append("\n");
        sb.append("    maxBytes: ").append(this.toIndentedString(this.maxBytes)).append("\n");
        sb.append("    temperature: ").append(this.toIndentedString(this.temperature)).append("\n");
        sb.append("    systemPrompt: ").append(this.toIndentedString(this.systemPrompt)).append("\n");
        sb.append("    topP: ").append(this.toIndentedString(this.topP)).append("\n");
        sb.append("    topK: ").append(this.toIndentedString(this.topK)).append("\n");
        sb.append("    stopSequences: ").append(this.toIndentedString(this.stopSequences)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    maxOutputTokens: ").append(this.toIndentedString(this.maxOutputTokens)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

