/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import org.jdesktop.http.NameValuePair;

public class Cookie
extends NameValuePair {
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version;

    public void setComment(String string) {
        String string2 = this.getComment();
        this.comment = string;
        this.firePropertyChange("comment", string2, this.getComment());
    }

    public String getComment() {
        return this.comment;
    }

    public void setDomain(String string) {
        String string2 = this.getDomain();
        this.domain = string;
        this.firePropertyChange("domain", string2, this.getDomain());
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(int n) {
        int n2 = this.getMaxAge();
        this.maxAge = n;
        this.firePropertyChange("maxAge", n2, this.getMaxAge());
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String string) {
        String string2 = this.getPath();
        this.path = string;
        this.firePropertyChange("path", string2, this.getPath());
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean bl) {
        boolean bl2 = this.isSecure();
        this.secure = bl;
        this.firePropertyChange("secure", bl2, this.isSecure());
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setVersion(int n) {
        int n2 = this.getVersion();
        this.version = n;
        this.firePropertyChange("version", n2, this.getVersion());
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public String toString() {
        return "Cookie [" + this.getName() + "=" + this.getValue() + ", Comment=" + this.getComment() + ", Domain=" + this.getDomain() + ", Max-Age=" + this.getMaxAge() + ", Path=" + this.getPath() + ", Secure=" + this.isSecure() + ", Version=" + this.getVersion() + "]";
    }

    public static Cookie parseCookie(String string) throws RuntimeException {
        Cookie cookie = new Cookie();
        if (string == null) {
            throw new NullPointerException("Cannot parse a null value");
        }
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl2 = !bl2;
                continue;
            }
            if (c == '=' && !bl2 && n3 == -1) {
                n3 = i;
                continue;
            }
            if (c != ';' || bl2) continue;
            n2 = i;
            Cookie.handle(cookie, string, n, n3, n2, bl);
            n = n2 + 1;
            n3 = -1;
            bl = false;
        }
        if (n >= 0) {
            Cookie.handle(cookie, string, n, n3, string.length(), bl);
        }
        return cookie;
    }

    private static void handle(Cookie cookie, String string, int n, int n2, int n3, boolean bl) throws RuntimeException {
        String string2 = null;
        Object object = null;
        if (n2 > -1) {
            string2 = string.substring(n, n2).trim();
            object = string.substring(n2 + 1, n3).trim();
        } else {
            string2 = string.substring(n, n3).trim();
        }
        if (object != null && ((String)object).charAt(0) == '\"' && ((String)object).charAt(((String)object).length() - 1) == '\"') {
            object = ((String)object).substring(1, ((String)object).length() - 1);
        }
        if (bl) {
            if (string2.startsWith("$")) {
                throw new RuntimeException("The firs av-pair cannot begin with a $");
            }
            cookie.setName(string2);
            cookie.setValue((String)object);
        } else if ("Comment".equalsIgnoreCase(string2)) {
            cookie.setComment((String)object);
        } else if ("Domain".equalsIgnoreCase(string2)) {
            if (!((String)object).startsWith(".")) {
                object = "." + (String)object;
            }
            cookie.setDomain((String)object);
        } else if ("Max-Age".equalsIgnoreCase(string2)) {
            int n4 = Integer.parseInt((String)object);
            if (n4 < 0) {
                throw new RuntimeException("Max age must be non-negative");
            }
            cookie.setMaxAge(n4);
        } else if ("Path".equalsIgnoreCase(string2)) {
            cookie.setPath((String)object);
        } else if ("Secure".equalsIgnoreCase(string2)) {
            cookie.setSecure(true);
        } else if ("Version".equalsIgnoreCase(string2)) {
            cookie.setVersion(Integer.parseInt((String)object));
        } else if ("Expires".equalsIgnoreCase(string2)) {
            System.err.println("Expires not yet handled");
        } else if ("Discard".equalsIgnoreCase(string2)) {
            System.err.println("Discard not yet handled");
        } else if ("Port".equalsIgnoreCase(string2)) {
            System.err.println("Port not yet handled");
        } else if ("CommentURL".equalsIgnoreCase(string2)) {
            System.err.println("CommentURL not yet handled");
        } else {
            System.err.println("Warning: Skipping " + string2 + "=" + (String)object);
        }
    }
}

