/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http.async;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jdesktop.dom.SimpleDocument;
import org.jdesktop.dom.SimpleDocumentBuilder;
import org.jdesktop.http.Method;
import org.jdesktop.http.async.AsyncHttpRequest;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XmlHttpRequest
extends AsyncHttpRequest {
    private SimpleDocument responseXML;

    public final SimpleDocument getResponseXML() {
        if (this.getReadyState() == AsyncHttpRequest.ReadyState.LOADED) {
            return this.responseXML;
        }
        return null;
    }

    @Override
    protected void reset() {
        this.setResponseXML(null);
        super.reset();
    }

    @Override
    protected void handleResponse(String string) throws Exception {
        if (string == null) {
            this.setResponseXML(null);
        } else {
            String string2 = this.getResponseHeader("Content-Type");
            if (string2 != null && string2.toUpperCase().contains("XML")) {
                try {
                    this.setResponseXML(SimpleDocumentBuilder.simpleParse(string));
                }
                catch (Exception exception) {
                    this.setResponseXML(null);
                    throw exception;
                }
            } else {
                this.setResponseXML(null);
            }
        }
    }

    private void setResponseXML(SimpleDocument simpleDocument) {
        SimpleDocument simpleDocument2 = this.responseXML;
        this.responseXML = simpleDocument;
        this.firePropertyChange("responseXML", simpleDocument2, this.responseXML);
    }

    public static void printDocument(Document document, OutputStream outputStream) throws IOException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(document), new StreamResult(new OutputStreamWriter(outputStream, "UTF-8")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        final XmlHttpRequest xmlHttpRequest = new XmlHttpRequest();
        xmlHttpRequest.addReadyStateChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() == AsyncHttpRequest.ReadyState.LOADED) {
                    System.out.println("LOADED");
                    System.out.println(xmlHttpRequest.getStatus());
                    System.out.println(xmlHttpRequest.getStatusText());
                    System.out.println(xmlHttpRequest.getException());
                    System.out.println(xmlHttpRequest.getResponseText());
                    SimpleDocument simpleDocument = xmlHttpRequest.getResponseXML();
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    try {
                        XPathExpression xPathExpression = xPath.compile("/Envelope/Body/GetCitiesByCountryResponse/GetCitiesByCountryResult");
                        NodeList nodeList = (NodeList)xPathExpression.evaluate(simpleDocument, XPathConstants.NODESET);
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            System.out.println(nodeList.item(i).getTextContent());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (propertyChangeEvent.getNewValue() == AsyncHttpRequest.ReadyState.RECEIVING) {
                    System.out.println("RECEIVING");
                    System.out.println(xmlHttpRequest.getResponseText());
                    SimpleDocument simpleDocument = xmlHttpRequest.getResponseXML();
                    try {
                        XmlHttpRequest.printDocument(simpleDocument, System.out);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        try {
            xmlHttpRequest.open(Method.GET, "http://www.webservicex.net/globalweather.asmx");
            xmlHttpRequest.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
            xmlHttpRequest.send("<?xml version=\"1.0\" encoding=\"utf-8\"?><soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><GetCitiesByCountry xmlns=\"http://www.webserviceX.NET\"><CountryName>US</CountryName></GetCitiesByCountry>  </soap:Body></soap:Envelope>");
            XmlHttpRequest xmlHttpRequest2 = xmlHttpRequest;
            synchronized (xmlHttpRequest2) {
                xmlHttpRequest.wait(20000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

