/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xpath;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jdesktop.dom.SimpleNodeList;
import org.jdesktop.xpath.function.XPathFunctionResolverImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtils {
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    private static final XPathFunctionResolverImpl functionResolver = new XPathFunctionResolverImpl();

    private XPathUtils() {
    }

    public static synchronized SimpleNodeList getElements(String string, Node node) throws XPathExpressionException {
        SimpleNodeList simpleNodeList = new SimpleNodeList((NodeList)xpath.evaluate(string, node, XPathConstants.NODESET));
        return simpleNodeList;
    }

    public static synchronized Node getElement(String string, Node node) throws XPathExpressionException {
        Node node2 = (Node)xpath.evaluate(string, node, XPathConstants.NODE);
        return node2;
    }

    public static synchronized String getString(String string, Node node) throws XPathExpressionException {
        Node node2 = (Node)xpath.evaluate(string, node, XPathConstants.NODE);
        return node2 == null ? null : node2.getTextContent();
    }

    public static synchronized String getString(String string, Node node, String string2, String string3) throws XPathExpressionException {
        functionResolver.addNamespaceMapping(string3, string2);
        Node node2 = (Node)xpath.evaluate(string, node, XPathConstants.NODE);
        functionResolver.removeNamespaceMapping(string3);
        return node2 == null ? null : node2.getTextContent();
    }

    public static synchronized SimpleNodeList getElements(XPathExpression xPathExpression, Node node) throws XPathExpressionException {
        SimpleNodeList simpleNodeList = new SimpleNodeList((NodeList)xPathExpression.evaluate(node, XPathConstants.NODESET));
        return simpleNodeList;
    }

    public static synchronized Node getElement(XPathExpression xPathExpression, Node node) throws XPathExpressionException {
        Node node2 = (Node)xPathExpression.evaluate(node, XPathConstants.NODE);
        return node2;
    }

    public static synchronized String getString(XPathExpression xPathExpression, Node node) throws XPathExpressionException {
        Node node2 = (Node)xPathExpression.evaluate(node, XPathConstants.NODE);
        return node2 == null ? null : node2.getTextContent();
    }

    public static synchronized XPathExpression compile(String string) throws XPathExpressionException {
        return xpath.compile(string);
    }

    public static String toXML(Document document) {
        return XPathUtils.toXML(document, null);
    }

    public static String toXML(Document document, Properties properties) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (properties != null) {
                transformer.setOutputProperties(properties);
            }
            transformer.transform(dOMSource, streamResult);
            String string = stringWriter.toString();
            stringWriter.close();
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static {
        xpath.setNamespaceContext(functionResolver);
        xpath.setXPathFunctionResolver(functionResolver);
    }
}

