/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xpath.function;

import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractFunction
implements XPathFunction {
    private int arity;
    private String name;

    protected AbstractFunction(String string, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new IllegalArgumentException("Arity must be positive");
        }
        this.arity = n;
        this.name = string;
    }

    public final int getArity() {
        return this.arity;
    }

    public final String getName() {
        return this.name;
    }

    protected String getStringParam(Object object) throws XPathFunctionException {
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Boolean) {
            string = object.toString();
        } else if (object instanceof Double) {
            string = object.toString();
        } else if (object instanceof NodeList) {
            NodeList nodeList = (NodeList)object;
            Node node = nodeList.item(0);
            string = node.getTextContent();
        } else {
            throw new XPathFunctionException("Could not convert argument type");
        }
        return string;
    }

    protected Number getNumberParam(Object object) throws XPathFunctionException {
        Double d;
        block5: {
            d = null;
            try {
                if (object instanceof String) {
                    d = Double.parseDouble((String)object);
                    break block5;
                }
                if (object instanceof Double) {
                    d = (Double)object;
                    break block5;
                }
                if (object instanceof NodeList) {
                    NodeList nodeList = (NodeList)object;
                    Node node = nodeList.item(0);
                    d = Double.parseDouble(node.getTextContent());
                    break block5;
                }
                throw new XPathFunctionException("Could not convert argument type");
            }
            catch (NumberFormatException numberFormatException) {
                throw new XPathFunctionException(numberFormatException);
            }
        }
        return d;
    }
}

