/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xpath.function;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.jdesktop.xpath.function.Abs;
import org.jdesktop.xpath.function.AbstractFunction;
import org.jdesktop.xpath.function.EndsWith;
import org.jdesktop.xpath.function.EqualsIgnoreCase;
import org.jdesktop.xpath.function.EscapeUri;
import org.jdesktop.xpath.function.LowerCase;
import org.jdesktop.xpath.function.Matches;
import org.jdesktop.xpath.function.Replace;
import org.jdesktop.xpath.function.UpperCase;

public class XPathFunctionResolverImpl
implements XPathFunctionResolver,
NamespaceContext {
    private static final String NAMESPACE = "http://swinglabs.org/xpath/fn";
    private static Map<Signature, XPathFunction> functions = new HashMap<Signature, XPathFunction>();
    private static Map<String, String> namespaces = new HashMap<String, String>();

    @Override
    public XPathFunction resolveFunction(QName qName, int n) {
        return functions.get(new Signature(qName, n));
    }

    public static void installFunction(AbstractFunction abstractFunction) {
        functions.put(new Signature(new QName(NAMESPACE, abstractFunction.getName()), abstractFunction.getArity()), abstractFunction);
    }

    @Override
    public String getNamespaceURI(String string) {
        if (string == null) {
            throw new NullPointerException("Null prefix");
        }
        if ("fn".equals(string)) {
            return NAMESPACE;
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        string = string.intern();
        System.out.println("looking for prefix: " + string);
        for (String string2 : namespaces.keySet()) {
            System.out.println(string2);
        }
        if (namespaces.containsKey(string)) {
            System.out.println("it contains the key: " + string);
            return namespaces.get(string);
        }
        return "";
    }

    @Override
    public String getPrefix(String string) {
        throw new UnsupportedOperationException();
    }

    public Iterator getPrefixes(String string) {
        throw new UnsupportedOperationException();
    }

    public void addNamespaceMapping(String string, String string2) {
        namespaces.put(string.intern(), string2.intern());
    }

    public void removeNamespaceMapping(String string) {
        namespaces.remove(string.intern());
    }

    static {
        XPathFunctionResolverImpl.installFunction(new Abs());
        XPathFunctionResolverImpl.installFunction(new EndsWith());
        XPathFunctionResolverImpl.installFunction(new EscapeUri());
        XPathFunctionResolverImpl.installFunction(new LowerCase());
        XPathFunctionResolverImpl.installFunction(new Matches());
        XPathFunctionResolverImpl.installFunction(new Replace());
        XPathFunctionResolverImpl.installFunction(new UpperCase());
        XPathFunctionResolverImpl.installFunction(new EqualsIgnoreCase());
    }

    private static final class Signature {
        private QName functionName;
        private int arity;

        public Signature(QName qName, int n) {
            this.functionName = qName;
            this.arity = n;
        }

        public boolean equals(Object object) {
            if (object instanceof Signature) {
                Signature signature = (Signature)object;
                return signature.arity == this.arity && signature.functionName.equals(this.functionName);
            }
            return false;
        }

        public int hashCode() {
            return this.functionName.hashCode() + this.arity;
        }
    }
}

