/*
 * Decompiled with CFR 0.152.
 */
package org.osiam;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Order(value=-2147483639)
public class OsiamHome
implements ApplicationListener<ApplicationEvent> {
    private static final Logger logger = LoggerFactory.getLogger(OsiamHome.class);
    private boolean hasInitializedHome = false;
    private boolean shouldInitializeHome = true;
    private Path osiamHome;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            ConfigurableEnvironment environment = ((ApplicationEnvironmentPreparedEvent)event).getEnvironment();
            this.configure(environment);
            if (this.shouldInitializeHome) {
                this.initialize();
            }
        } else if (event instanceof ApplicationPreparedEvent) {
            this.writeLogs();
        }
    }

    public void configure(ConfigurableEnvironment environment) {
        String rawOsiamHome = environment.getProperty("osiam.home", String.valueOf(System.getenv("HOME")) + "/.osiam");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)rawOsiamHome) ? 1 : 0) != 0, (Object)"'osiam.home' is not set");
        this.osiamHome = Paths.get(rawOsiamHome, new String[0]).toAbsolutePath();
        environment.getPropertySources().addFirst((PropertySource)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void initialize() {
        try {
            Resource[] resources;
            if (Files.notExists(this.osiamHome, new LinkOption[0])) {
                Files.createDirectories(this.osiamHome, new FileAttribute[0]);
            } else {
                Preconditions.checkState((boolean)Files.isDirectory(this.osiamHome, new LinkOption[0]), (String)"'osiam.home' (%s) is not a directory", (Object[])new Object[]{this.osiamHome});
                Preconditions.checkState((boolean)Files.isReadable(this.osiamHome), (String)"'osiam.home' (%s) is not readable", (Object[])new Object[]{this.osiamHome});
                Preconditions.checkState((boolean)Files.isExecutable(this.osiamHome), (String)"'osiam.home' (%s) is not accessible", (Object[])new Object[]{this.osiamHome});
            }
            if (!this.isEmpty(this.osiamHome)) {
                return;
            }
            Preconditions.checkState((boolean)Files.isWritable(this.osiamHome), (String)"'osiam.home' (%s) is not writable", (Object[])new Object[]{this.osiamHome});
            Resource[] resourceArray = resources = new PathMatchingResourcePatternResolver().getResources("classpath:/home/**/*");
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                if (!resource.getURL().toString().endsWith("/")) {
                    this.copyToHome(resource, this.osiamHome);
                }
                ++n2;
            }
            if (Files.notExists(this.osiamHome.resolve("data"), new LinkOption[0])) {
                Files.createDirectories(this.osiamHome.resolve("data"), new FileAttribute[0]);
            }
            this.hasInitializedHome = true;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not initialize osiam.home", e);
        }
    }

    public void writeLogs() {
        logger.info("osiam.home = {}", (Object)this.osiamHome);
        if (this.hasInitializedHome) {
            logger.info("Initialized osiam.home");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEmpty(Path directory) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            return !directoryStream.iterator().hasNext();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void copyToHome(Resource resource, Path osiamHomeDir) throws IOException {
        String pathUnderHome = resource.getURL().toString().replaceFirst(".*home/", "");
        Path target = osiamHomeDir.resolve(pathUnderHome);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Files.copy(resource.getInputStream(), target, StandardCopyOption.REPLACE_EXISTING);
    }

    public void shouldInitializeHome(boolean shouldInitializeHome) {
        this.shouldInitializeHome = shouldInitializeHome;
    }
}

