/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.auth.oauth_client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.provider.ClientDetails;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Entity
@Table(name="osiam_client")
public class ClientEntity
implements ClientDetails {
    private static final int ID_LENGTH = 32;
    private static final int SEQUENCE_INITIAL_VALUE = 100;
    private static final int SEQUENCE_ALLOCATION_SIZE = 1;
    @Id
    @SequenceGenerator(name="sequence_osiam_client", sequenceName="auth_server_sequence_osiam_client", allocationSize=1, initialValue=100)
    @GeneratedValue(generator="sequence_osiam_client")
    @JsonIgnore
    private long internalId;
    @JsonProperty
    @Column(unique=true, nullable=false, length=32)
    private String id;
    @JsonProperty
    private int accessTokenValiditySeconds;
    @JsonProperty
    private int refreshTokenValiditySeconds;
    @JsonProperty
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(nullable=false)
    private String redirectUri;
    @JsonProperty(value="client_secret")
    @Column(nullable=false)
    private String clientSecret = UUID.randomUUID().toString();
    @JsonProperty
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="osiam_client_scopes", joinColumns={@JoinColumn(name="id")})
    private Set<String> scope;
    @JsonProperty
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="osiam_client_grants", joinColumns={@JoinColumn(name="id")})
    private Set<String> grants = Sets.newHashSet((Object[])new String[]{"authorization_code", "refresh_token"});
    @JsonProperty
    @Column(name="implicit_approval", nullable=false)
    private boolean implicit;
    @JsonProperty
    @Column(nullable=false)
    private long validityInSeconds;

    public long getInternalId() {
        return this.internalId;
    }

    public Integer getAccessTokenValiditySeconds() {
        return this.accessTokenValiditySeconds;
    }

    public Integer getRefreshTokenValiditySeconds() {
        return this.refreshTokenValiditySeconds;
    }

    @JsonIgnore
    public boolean isAutoApprove(String scope) {
        return this.implicit;
    }

    @JsonIgnore
    public Map<String, Object> getAdditionalInformation() {
        return Collections.singletonMap("validityInSeconds", this.validityInSeconds);
    }

    @JsonIgnore
    public String getClientId() {
        return this.id;
    }

    @JsonIgnore
    public Set<String> getResourceIds() {
        return Collections.emptySet();
    }

    @JsonIgnore
    public boolean isSecretRequired() {
        return true;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonIgnore
    public boolean isScoped() {
        return true;
    }

    public Set<String> getScope() {
        return Collections.unmodifiableSet(this.scope);
    }

    @JsonIgnore
    public Set<String> getAuthorizedGrantTypes() {
        return Collections.unmodifiableSet(this.grants);
    }

    @JsonIgnore
    public Set<String> getRegisteredRedirectUri() {
        return Collections.singleton(this.redirectUri);
    }

    @JsonIgnore
    public Collection<GrantedAuthority> getAuthorities() {
        return Collections.emptySet();
    }

    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    public void setClientId(String clientId) {
        this.id = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setGrants(Collection<String> grants) {
        this.grants = new LinkedHashSet<String>(grants);
    }

    public void setScope(Collection<String> scope) {
        this.scope = new LinkedHashSet<String>(scope);
    }

    public void setAccessTokenValiditySeconds(int accessTokenValiditySeconds) {
        this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    public void setRefreshTokenValiditySeconds(int refreshTokenValiditySeconds) {
        this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public void setValidityInSeconds(long validity) {
        this.validityInSeconds = validity;
    }
}

