/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.configuration;

import org.apache.catalina.connector.Connector;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="osiam.ajp", name={"enabled"})
public class AjpConfiguration
implements EmbeddedServletContainerCustomizer {
    @Value(value="${osiam.ajp.bind-address:127.0.0.1}")
    private String bindAddress;
    @Value(value="${osiam.ajp.port:8009}")
    private int port;

    public void customize(ConfigurableEmbeddedServletContainer container) {
        if (container instanceof TomcatEmbeddedServletContainerFactory) {
            TomcatEmbeddedServletContainerFactory tomcat = (TomcatEmbeddedServletContainerFactory)container;
            Connector ajpConnector = new Connector("AJP/1.3");
            ajpConnector.setAttribute("address", (Object)this.bindAddress);
            ajpConnector.setPort(this.port);
            ajpConnector.setSecure(false);
            ajpConnector.setAllowTrace(false);
            ajpConnector.setScheme("http");
            tomcat.addAdditionalTomcatConnectors(new Connector[]{ajpConnector});
        }
    }
}

