/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.configuration;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class DatabaseConfiguration {
    @Value(value="${osiam.db.driver}")
    private String driverClassName;
    @Value(value="${osiam.db.url}")
    private String databaseUrl;
    @Value(value="${osiam.db.username}")
    private String databaseUserName;
    @Value(value="${osiam.db.password}")
    private String databasePassword;
    @Value(value="${osiam.db.vendor}")
    private String databaseVendor;
    @Value(value="${osiam.db.maximum-pool-size:10}")
    private int maximumPoolSize;
    @Value(value="${osiam.db.connection-timeout-ms:30000}")
    private int connectionTimeoutMs;

    @Primary
    @Bean
    public DataSource dataSource() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setPoolName("osiam-cp");
        hikariConfig.setDriverClassName(this.driverClassName);
        hikariConfig.setJdbcUrl(this.databaseUrl);
        hikariConfig.setUsername(this.databaseUserName);
        hikariConfig.setPassword(this.databasePassword);
        hikariConfig.setMaximumPoolSize(this.maximumPoolSize);
        hikariConfig.setConnectionTimeout((long)this.connectionTimeoutMs);
        return new HikariDataSource(hikariConfig);
    }

    @Bean
    public Flyway flyway() {
        Flyway flyway = new Flyway();
        flyway.setDataSource(this.dataSource());
        flyway.setLocations(new String[]{"db/migration/" + this.databaseVendor});
        flyway.setBaselineOnMigrate(true);
        flyway.setBaselineVersion(MigrationVersion.fromVersion((String)"1"));
        flyway.migrate();
        return flyway;
    }
}

