/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.configuration;

import javax.servlet.Filter;
import org.osiam.auth.login.OsiamCachingAuthenticationFailureHandler;
import org.osiam.auth.login.internal.InternalAuthenticationProvider;
import org.osiam.auth.login.ldap.OsiamLdapAuthenticationProvider;
import org.osiam.security.helper.LoginDecisionFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@Order(value=2)
@EnableWebSecurity
public class WebApplicationSecurity
extends WebSecurityConfigurerAdapter {
    @Autowired
    private InternalAuthenticationProvider internalAuthenticationProvider;
    @Autowired(required=false)
    private OsiamLdapAuthenticationProvider osiamLdapAuthenticationProvider;

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/css/**", "/js/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        LoginDecisionFilter loginDecisionFilter = new LoginDecisionFilter();
        loginDecisionFilter.setAuthenticationManager(this.authenticationManagerBean());
        SavedRequestAwareAuthenticationSuccessHandler successHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        successHandler.setAlwaysUseDefaultTargetUrl(false);
        loginDecisionFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)successHandler);
        loginDecisionFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)new OsiamCachingAuthenticationFailureHandler("/login/error"));
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().antMatchers(new String[]{"/login/**", "/error", "/oauth/**"})).and().authorizeRequests().antMatchers(new String[]{"/login", "/login/error", "/error"})).permitAll().anyRequest()).authenticated().and()).csrf().disable()).exceptionHandling().accessDeniedPage("/login/error").and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.ALWAYS).and()).formLogin().loginProcessingUrl("/login/check")).failureUrl("/login/error")).loginPage("/login").and()).addFilterBefore((Filter)loginDecisionFilter, UsernamePasswordAuthenticationFilter.class);
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.internalAuthenticationProvider);
        if (this.osiamLdapAuthenticationProvider != null) {
            auth.authenticationProvider((AuthenticationProvider)this.osiamLdapAuthenticationProvider);
        }
    }

    @Bean(name={"authenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }
}

