/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.controller;

import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.osiam.resources.scim.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ResourceController<T extends Resource> {
    protected ResponseEntity<MappingJacksonValue> buildResponseWithLocation(T resource, UriComponentsBuilder builder, HttpStatus status, String attributes) {
        HttpHeaders headers = new HttpHeaders();
        URI location = this.buildLocation(resource, builder);
        headers.setLocation(location);
        MappingJacksonValue response = this.buildResponse(resource, attributes);
        return new ResponseEntity((Object)response, (MultiValueMap)headers, status);
    }

    protected URI buildLocation(T resource, UriComponentsBuilder builder) {
        String resourceType = resource.getSchemas().contains("urn:ietf:params:scim:schemas:core:2.0:User") ? "Users" : "Groups";
        return builder.path("/{resource}/{id}").buildAndExpand(new Object[]{resourceType, resource.getId()}).toUri();
    }

    private Set<String> extractAttributes(String attributesParameter) {
        HashSet result = new HashSet();
        if (!Strings.isNullOrEmpty((String)attributesParameter)) {
            result = Sets.newHashSet((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)".,")).trimResults().omitEmptyStrings().split((CharSequence)attributesParameter));
        }
        result.add("schemas");
        result.add("id");
        return result;
    }

    protected MappingJacksonValue buildResponse(Object resource, String attributes) {
        MappingJacksonValue wrapper = new MappingJacksonValue(resource);
        if (!Strings.isNullOrEmpty((String)attributes)) {
            Set attributesSet = this.extractAttributes(attributes);
            SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("attributeFilter", SimpleBeanPropertyFilter.filterOutAllExcept((Set)attributesSet));
            wrapper.setFilters((FilterProvider)filterProvider);
        }
        return wrapper;
    }
}

