/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osiam.resources.converter.AddressConverter;
import org.osiam.resources.converter.Converter;
import org.osiam.resources.converter.EmailConverter;
import org.osiam.resources.converter.EntitlementConverter;
import org.osiam.resources.converter.ExtensionConverter;
import org.osiam.resources.converter.ImConverter;
import org.osiam.resources.converter.MetaConverter;
import org.osiam.resources.converter.NameConverter;
import org.osiam.resources.converter.PhoneNumberConverter;
import org.osiam.resources.converter.PhotoConverter;
import org.osiam.resources.converter.RoleConverter;
import org.osiam.resources.converter.X509CertificateConverter;
import org.osiam.resources.scim.Extension;
import org.osiam.resources.scim.GroupRef;
import org.osiam.resources.scim.User;
import org.osiam.storage.entities.AddressEntity;
import org.osiam.storage.entities.EmailEntity;
import org.osiam.storage.entities.EntitlementEntity;
import org.osiam.storage.entities.ExtensionFieldValueEntity;
import org.osiam.storage.entities.GroupEntity;
import org.osiam.storage.entities.ImEntity;
import org.osiam.storage.entities.PhoneNumberEntity;
import org.osiam.storage.entities.PhotoEntity;
import org.osiam.storage.entities.RoleEntity;
import org.osiam.storage.entities.UserEntity;
import org.osiam.storage.entities.X509CertificateEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserConverter
implements Converter<User, UserEntity> {
    private final X509CertificateConverter x509CertificateConverter;
    private final RoleConverter roleConverter;
    private final PhotoConverter photoConverter;
    private final PhoneNumberConverter phoneNumberConverter;
    private final ImConverter imConverter;
    private final EntitlementConverter entitlementConverter;
    private final EmailConverter emailConverter;
    private final AddressConverter addressConverter;
    private final NameConverter nameConverter;
    private final ExtensionConverter extensionConverter;
    private final MetaConverter metaConverter;

    @Autowired
    public UserConverter(X509CertificateConverter x509CertificateConverter, RoleConverter roleConverter, PhotoConverter photoConverter, PhoneNumberConverter phoneNumberConverter, ImConverter imConverter, EntitlementConverter entitlementConverter, EmailConverter emailConverter, AddressConverter addressConverter, NameConverter nameConverter, ExtensionConverter extensionConverter, MetaConverter metaConverter) {
        this.x509CertificateConverter = x509CertificateConverter;
        this.roleConverter = roleConverter;
        this.photoConverter = photoConverter;
        this.phoneNumberConverter = phoneNumberConverter;
        this.imConverter = imConverter;
        this.entitlementConverter = entitlementConverter;
        this.emailConverter = emailConverter;
        this.addressConverter = addressConverter;
        this.nameConverter = nameConverter;
        this.extensionConverter = extensionConverter;
        this.metaConverter = metaConverter;
    }

    public UserEntity fromScim(User user) {
        if (user == null) {
            return null;
        }
        UserEntity userEntity = new UserEntity();
        if (user.getPassword() != null && !user.getPassword().isEmpty()) {
            userEntity.setPassword(user.getPassword());
        }
        if (user.isActive() != null) {
            userEntity.setActive(user.isActive());
        }
        userEntity.setDisplayName(user.getDisplayName());
        userEntity.setNickName(user.getNickName());
        userEntity.setExternalId(user.getExternalId() == null ? null : (user.getExternalId().isEmpty() ? null : user.getExternalId()));
        userEntity.setPreferredLanguage(user.getPreferredLanguage());
        userEntity.setLocale(user.getLocale());
        userEntity.setProfileUrl(user.getProfileUrl());
        userEntity.setTimezone(user.getTimezone());
        userEntity.setTitle(user.getTitle());
        userEntity.setUserName(user.getUserName());
        userEntity.setUserType(user.getUserType());
        userEntity.setName(this.nameConverter.fromScim(user.getName()));
        Set addresses = this.convertMultiValueFromScim((Converter)this.addressConverter, new HashSet(user.getAddresses()));
        for (AddressEntity addressEntity : addresses) {
            userEntity.addAddress(addressEntity);
        }
        Set emails = this.convertMultiValueFromScim((Converter)this.emailConverter, new HashSet(user.getEmails()));
        for (EmailEntity emailEntity : emails) {
            userEntity.addEmail(emailEntity);
        }
        Set entitlements = this.convertMultiValueFromScim((Converter)this.entitlementConverter, new HashSet(user.getEntitlements()));
        for (EntitlementEntity entitlementEntity : entitlements) {
            userEntity.addEntitlement(entitlementEntity);
        }
        Set ims = this.convertMultiValueFromScim((Converter)this.imConverter, new HashSet(user.getIms()));
        for (ImEntity imEntity : ims) {
            userEntity.addIm(imEntity);
        }
        Set phoneNumbers = this.convertMultiValueFromScim((Converter)this.phoneNumberConverter, new HashSet(user.getPhoneNumbers()));
        for (PhoneNumberEntity phoneNumberEntity : phoneNumbers) {
            userEntity.addPhoneNumber(phoneNumberEntity);
        }
        Set photos = this.convertMultiValueFromScim((Converter)this.photoConverter, new HashSet(user.getPhotos()));
        for (PhotoEntity photoEntity : photos) {
            userEntity.addPhoto(photoEntity);
        }
        Set roles = this.convertMultiValueFromScim((Converter)this.roleConverter, new HashSet(user.getRoles()));
        for (RoleEntity roleEntity : roles) {
            userEntity.addRole(roleEntity);
        }
        Set x509Certificates = this.convertMultiValueFromScim((Converter)this.x509CertificateConverter, new HashSet(user.getX509Certificates()));
        for (X509CertificateEntity x509CertificateEntity : x509Certificates) {
            userEntity.addX509Certificate(x509CertificateEntity);
        }
        Set fieldValues = this.extensionConverter.fromScim(new HashSet(user.getExtensions().values()));
        for (ExtensionFieldValueEntity fieldValue : fieldValues) {
            userEntity.addOrUpdateExtensionValue(fieldValue);
        }
        return userEntity;
    }

    public User toScim(UserEntity entity) {
        if (entity == null) {
            return null;
        }
        User.Builder userBuilder = new User.Builder(entity.getUserName()).setActive(entity.getActive()).setDisplayName(entity.getDisplayName()).setLocale(entity.getLocale()).setName(entity.getName() != null ? this.nameConverter.toScim(entity.getName()) : null).setNickName(entity.getNickName()).setPassword(entity.getPassword()).setPreferredLanguage(entity.getPreferredLanguage()).setProfileUrl(entity.getProfileUrl()).setTimezone(entity.getTimezone()).setTitle(entity.getTitle()).setUserType(entity.getUserType()).setExternalId(entity.getExternalId()).setId(entity.getId().toString()).setMeta(this.metaConverter.toScim(entity.getMeta())).addAddresses((Collection)this.convertMultiValueToScim((Converter)this.addressConverter, entity.getAddresses())).addEmails((Collection)this.convertMultiValueToScim((Converter)this.emailConverter, entity.getEmails())).addEntitlements((Collection)this.convertMultiValueToScim((Converter)this.entitlementConverter, entity.getEntitlements())).setGroups(this.entityGroupsToScim(entity.getGroups())).addIms((Collection)this.convertMultiValueToScim((Converter)this.imConverter, entity.getIms())).addPhoneNumbers((Collection)this.convertMultiValueToScim((Converter)this.phoneNumberConverter, entity.getPhoneNumbers())).addPhotos((Collection)this.convertMultiValueToScim((Converter)this.photoConverter, entity.getPhotos())).addRoles((Collection)this.convertMultiValueToScim((Converter)this.roleConverter, entity.getRoles())).addX509Certificates((Collection)this.convertMultiValueToScim((Converter)this.x509CertificateConverter, entity.getX509Certificates()));
        this.addExtensions(userBuilder, entity.getExtensionFieldValues());
        return userBuilder.build();
    }

    private void addExtensions(User.Builder userBuilder, Set<ExtensionFieldValueEntity> extensionFieldValues) {
        Set extensions = this.extensionConverter.toScim(extensionFieldValues);
        for (Extension extension : extensions) {
            userBuilder.addExtension(extension);
        }
    }

    private <S, E> Set<E> convertMultiValueFromScim(Converter<S, E> converter, Set<S> multiValues) {
        HashSet<Object> entities = new HashSet<Object>();
        for (S multiValue : multiValues) {
            Object entity = converter.fromScim(multiValue);
            entities.add(entity);
        }
        return entities;
    }

    private <S, E> List<S> convertMultiValueToScim(Converter<S, E> converter, Set<E> entities) {
        ArrayList<Object> multiValues = new ArrayList<Object>();
        for (E entity : entities) {
            Object multiValue = converter.toScim(entity);
            multiValues.add(multiValue);
        }
        return multiValues;
    }

    private List<GroupRef> entityGroupsToScim(Set<GroupEntity> groupEntities) {
        ArrayList<GroupRef> groupsForMapping = new ArrayList<GroupRef>();
        if (groupEntities != null) {
            for (GroupEntity groupEntity : groupEntities) {
                GroupRef groupRef = new GroupRef.Builder().setDisplay(groupEntity.getDisplayName()).setValue(groupEntity.getId().toString()).build();
                groupsForMapping.add(groupRef);
            }
        }
        return groupsForMapping;
    }
}

