/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning;

import java.util.ArrayList;
import java.util.UUID;
import org.antlr.v4.runtime.tree.ParseTree;
import org.osiam.resources.converter.GroupConverter;
import org.osiam.resources.exception.ResourceExistsException;
import org.osiam.resources.provisioning.SCIMProvisioning;
import org.osiam.resources.provisioning.update.GroupUpdater;
import org.osiam.resources.scim.Group;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.storage.dao.GroupDao;
import org.osiam.storage.dao.SearchResult;
import org.osiam.storage.entities.GroupEntity;
import org.osiam.storage.query.QueryFilterParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCIMGroupProvisioning
implements SCIMProvisioning<Group> {
    private final GroupConverter groupConverter;
    private final GroupDao groupDao;
    private final GroupUpdater groupUpdater;

    @Autowired
    public SCIMGroupProvisioning(GroupConverter groupConverter, GroupDao groupDao, GroupUpdater groupUpdater) {
        this.groupConverter = groupConverter;
        this.groupDao = groupDao;
        this.groupUpdater = groupUpdater;
    }

    public Group create(Group group) {
        if (this.groupDao.isDisplayNameAlreadyTaken(group.getDisplayName())) {
            throw new ResourceExistsException(String.format("Can't create a group. The displayname \"%s\" is already taken.", group.getDisplayName()));
        }
        if (this.groupDao.isExternalIdAlreadyTaken(group.getExternalId())) {
            throw new ResourceExistsException(String.format("Can't create a group. The externalId \"%s\" is already taken.", group.getExternalId()));
        }
        GroupEntity groupEntity = this.groupConverter.fromScim(group);
        groupEntity.setId(UUID.randomUUID());
        this.groupDao.create(groupEntity);
        return this.groupConverter.toScim(groupEntity);
    }

    public Group replace(String id, Group group) {
        if (this.groupDao.isDisplayNameAlreadyTaken(group.getDisplayName(), id)) {
            throw new ResourceExistsException(String.format("Can't replace the group with the id \"" + id + "\". The displayname \"%s\" is already taken.", group.getDisplayName()));
        }
        if (this.groupDao.isExternalIdAlreadyTaken(group.getExternalId(), id)) {
            throw new ResourceExistsException(String.format("Can't replace the group with the id \"" + id + "\". The externalId \"%s\" is already taken.", group.getExternalId()));
        }
        GroupEntity existingEntity = this.groupDao.getById(id);
        GroupEntity groupEntity = this.groupConverter.fromScim(group);
        groupEntity.setInternalId(existingEntity.getInternalId());
        groupEntity.setId(existingEntity.getId());
        groupEntity.setMeta(existingEntity.getMeta());
        groupEntity.touch();
        groupEntity = this.groupDao.update(groupEntity);
        return this.groupConverter.toScim(groupEntity);
    }

    public SCIMSearchResult<Group> search(String filter, String sortBy, String sortOrder, int count, int startIndex) {
        QueryFilterParser queryFilterParser = new QueryFilterParser();
        ArrayList<Group> groups = new ArrayList<Group>();
        ParseTree filterTree = queryFilterParser.getParseTree(filter);
        SearchResult result = this.groupDao.search(filterTree, sortBy, sortOrder, count, startIndex - 1);
        for (GroupEntity group : result.results) {
            groups.add(this.groupConverter.toScim(group));
        }
        return new SCIMSearchResult(groups, result.totalResults, (long)count, (long)startIndex);
    }

    public Group getById(String id) {
        return this.groupConverter.toScim(this.groupDao.getById(id));
    }

    public long count() {
        return this.groupDao.count();
    }

    public Group update(String id, Group group) {
        if (this.groupDao.isDisplayNameAlreadyTaken(group.getDisplayName(), id)) {
            throw new ResourceExistsException(String.format("Can't update the group with the id \"" + id + "\". The displayname \"%s\" is already taken.", group.getDisplayName()));
        }
        if (this.groupDao.isExternalIdAlreadyTaken(group.getExternalId(), id)) {
            throw new ResourceExistsException(String.format("Can't update the group with the id \"" + id + "\". The externalId \"%s\" is already taken.", group.getExternalId()));
        }
        GroupEntity groupEntity = this.groupDao.getById(id);
        this.groupUpdater.update(group, groupEntity);
        groupEntity.touch();
        return this.groupConverter.toScim(groupEntity);
    }

    public void delete(String id) {
        this.groupDao.delete(id);
    }
}

