/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning;

import java.util.ArrayList;
import java.util.UUID;
import org.antlr.v4.runtime.tree.ParseTree;
import org.osiam.resources.converter.UserConverter;
import org.osiam.resources.exception.ResourceExistsException;
import org.osiam.resources.provisioning.SCIMProvisioning;
import org.osiam.resources.provisioning.update.UserUpdater;
import org.osiam.resources.scim.SCIMSearchResult;
import org.osiam.resources.scim.User;
import org.osiam.storage.dao.SearchResult;
import org.osiam.storage.dao.UserDao;
import org.osiam.storage.entities.UserEntity;
import org.osiam.storage.query.QueryFilterParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SCIMUserProvisioning
implements SCIMProvisioning<User> {
    private final UserConverter userConverter;
    private final UserDao userDao;
    private final BCryptPasswordEncoder bCryptPasswordEncoder;
    private final UserUpdater userUpdater;

    @Autowired
    public SCIMUserProvisioning(UserConverter userConverter, UserDao userDao, BCryptPasswordEncoder bCryptPasswordEncoder, UserUpdater userUpdater) {
        this.userConverter = userConverter;
        this.userDao = userDao;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.userUpdater = userUpdater;
    }

    public User getById(String id) {
        UserEntity userEntity = this.userDao.getById(id);
        User user = this.userConverter.toScim(userEntity);
        return this.removePassword(user);
    }

    public long count() {
        return this.userDao.count();
    }

    public User getByUsername(String username) {
        return this.removePassword(this.getByUsernameWithPassword(username));
    }

    public User getByUsernameWithPassword(String username) {
        return this.userConverter.toScim(this.userDao.getByUsername(username));
    }

    public User create(User user) {
        if (this.userDao.isUserNameAlreadyTaken(user.getUserName())) {
            throw new ResourceExistsException(String.format("Can't create a user. The username \"%s\" is already taken.", user.getUserName()));
        }
        if (this.userDao.isExternalIdAlreadyTaken(user.getExternalId())) {
            throw new ResourceExistsException(String.format("Can't create a user. The externalId \"%s\" is already taken.", user.getExternalId()));
        }
        UserEntity userEntity = this.userConverter.fromScim(user);
        userEntity.setId(UUID.randomUUID());
        String hashedPassword = this.bCryptPasswordEncoder.encode((CharSequence)user.getPassword());
        userEntity.setPassword(hashedPassword);
        this.userDao.create(userEntity);
        return this.removePassword(this.userConverter.toScim(userEntity));
    }

    public User replace(String id, User user) {
        UserEntity existingEntity = this.userDao.getById(id);
        if (this.userDao.isUserNameAlreadyTaken(user.getUserName(), id)) {
            throw new ResourceExistsException(String.format("Can't replace the user with the id \"%s\". The username \"%s\" is already taken.", id, user.getUserName()));
        }
        if (this.userDao.isExternalIdAlreadyTaken(user.getExternalId(), id)) {
            throw new ResourceExistsException(String.format("Can't replace the user with the id \"%s\". The externalId \"%s\" is already taken.", id, user.getExternalId()));
        }
        UserEntity userEntity = this.userConverter.fromScim(user);
        userEntity.setInternalId(existingEntity.getInternalId());
        userEntity.setMeta(existingEntity.getMeta());
        userEntity.setId(existingEntity.getId());
        if (user.getPassword() != null && !user.getPassword().isEmpty()) {
            String hashedPassword = this.bCryptPasswordEncoder.encode((CharSequence)user.getPassword());
            userEntity.setPassword(hashedPassword);
        } else {
            userEntity.setPassword(existingEntity.getPassword());
        }
        userEntity.touch();
        userEntity = this.userDao.update(userEntity);
        return this.removePassword(this.userConverter.toScim(userEntity));
    }

    public SCIMSearchResult<User> search(String filter, String sortBy, String sortOrder, int count, int startIndex) {
        QueryFilterParser queryFilterParser = new QueryFilterParser();
        ArrayList<User> users = new ArrayList<User>();
        ParseTree filterTree = queryFilterParser.getParseTree(filter);
        SearchResult result = this.userDao.search(filterTree, sortBy, sortOrder, count, startIndex - 1);
        for (UserEntity userEntity : result.results) {
            User scimResultUser = this.userConverter.toScim(userEntity);
            users.add(this.removePassword(scimResultUser));
        }
        return new SCIMSearchResult(users, result.totalResults, (long)count, (long)startIndex);
    }

    public User update(String id, User user) {
        UserEntity userEntity = this.userDao.getById(id);
        if (this.userDao.isUserNameAlreadyTaken(user.getUserName(), id)) {
            throw new ResourceExistsException(String.format("Can't update the user with the id \"%s\". The username \"%s\" is already taken.", id, user.getUserName()));
        }
        if (this.userDao.isExternalIdAlreadyTaken(user.getExternalId(), id)) {
            throw new ResourceExistsException(String.format("Can't update the user with the id \"%s\". The externalId \"%s\" is already taken.", id, user.getExternalId()));
        }
        this.userUpdater.update(user, userEntity);
        userEntity.touch();
        return this.removePassword(this.userConverter.toScim(userEntity));
    }

    public void delete(String id) {
        this.userDao.delete(id);
    }

    private User removePassword(User user) {
        return new User.Builder(user).setPassword(null).build();
    }
}

