/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.osiam.resources.converter.EntitlementConverter;
import org.osiam.resources.scim.Entitlement;
import org.osiam.storage.entities.EntitlementEntity;
import org.osiam.storage.entities.UserEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class EntitlementsUpdater {
    private final EntitlementConverter entitlementConverter;

    @Autowired
    public EntitlementsUpdater(EntitlementConverter entitlementConverter) {
        this.entitlementConverter = entitlementConverter;
    }

    void update(List<Entitlement> entitlements, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("entitlements")) {
            userEntity.removeAllEntitlements();
        }
        if (entitlements != null) {
            for (Entitlement scimEntitlements : entitlements) {
                EntitlementEntity entitlementsEntity = this.entitlementConverter.fromScim(scimEntitlements);
                userEntity.removeEntitlement(entitlementsEntity);
                if (!Strings.isNullOrEmpty((String)scimEntitlements.getOperation()) && scimEntitlements.getOperation().equalsIgnoreCase("delete")) continue;
                this.ensureOnlyOnePrimaryEntitlementExists(entitlementsEntity, userEntity.getEntitlements());
                userEntity.addEntitlement(entitlementsEntity);
            }
        }
    }

    private void ensureOnlyOnePrimaryEntitlementExists(EntitlementEntity newEntitlement, Set<EntitlementEntity> entitlements) {
        if (newEntitlement.isPrimary()) {
            for (EntitlementEntity existingEntitlementEntity : entitlements) {
                if (!existingEntitlementEntity.isPrimary()) continue;
                existingEntitlementEntity.setPrimary(false);
            }
        }
    }
}

