/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.osiam.resources.converter.PhoneNumberConverter;
import org.osiam.resources.scim.PhoneNumber;
import org.osiam.storage.entities.PhoneNumberEntity;
import org.osiam.storage.entities.UserEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class PhoneNumberUpdater {
    private final PhoneNumberConverter phoneNumberConverter;

    @Autowired
    public PhoneNumberUpdater(PhoneNumberConverter phoneNumberConverter) {
        this.phoneNumberConverter = phoneNumberConverter;
    }

    void update(List<PhoneNumber> phoneNumbers, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("phoneNumbers")) {
            userEntity.removeAllPhoneNumbers();
        }
        if (phoneNumbers != null) {
            for (PhoneNumber scimPhoneNumber : phoneNumbers) {
                PhoneNumberEntity phoneNumberEntity = this.phoneNumberConverter.fromScim(scimPhoneNumber);
                userEntity.removePhoneNumber(phoneNumberEntity);
                if (!Strings.isNullOrEmpty((String)scimPhoneNumber.getOperation()) && scimPhoneNumber.getOperation().equalsIgnoreCase("delete")) continue;
                this.ensureOnlyOnePrimaryPhoneNumberExists(phoneNumberEntity, userEntity.getPhoneNumbers());
                userEntity.addPhoneNumber(phoneNumberEntity);
            }
        }
    }

    private void ensureOnlyOnePrimaryPhoneNumberExists(PhoneNumberEntity newPhoneNumber, Set<PhoneNumberEntity> phoneNumbers) {
        if (newPhoneNumber.isPrimary()) {
            for (PhoneNumberEntity existingPhoneNumberEntity : phoneNumbers) {
                if (!existingPhoneNumberEntity.isPrimary()) continue;
                existingPhoneNumberEntity.setPrimary(false);
            }
        }
    }
}

