/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.osiam.resources.converter.PhotoConverter;
import org.osiam.resources.scim.Photo;
import org.osiam.storage.entities.PhotoEntity;
import org.osiam.storage.entities.UserEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class PhotoUpdater {
    private final PhotoConverter photoConverter;

    @Autowired
    public PhotoUpdater(PhotoConverter photoConverter) {
        this.photoConverter = photoConverter;
    }

    void update(List<Photo> photos, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("photos")) {
            userEntity.removeAllPhotos();
        }
        if (photos != null) {
            for (Photo scimPhoto : photos) {
                PhotoEntity photoEntity = this.photoConverter.fromScim(scimPhoto);
                userEntity.removePhoto(photoEntity);
                if (!Strings.isNullOrEmpty((String)scimPhoto.getOperation()) && scimPhoto.getOperation().equalsIgnoreCase("delete")) continue;
                this.ensureOnlyOnePrimaryPhotoExists(photoEntity, userEntity.getPhotos());
                userEntity.addPhoto(photoEntity);
            }
        }
    }

    private void ensureOnlyOnePrimaryPhotoExists(PhotoEntity newPhoto, Set<PhotoEntity> photos) {
        if (newPhoto.isPrimary()) {
            for (PhotoEntity existingPhotoEntity : photos) {
                if (!existingPhotoEntity.isPrimary()) continue;
                existingPhotoEntity.setPrimary(false);
            }
        }
    }
}

