/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import org.osiam.resources.exception.ResourceExistsException;
import org.osiam.resources.scim.Resource;
import org.osiam.storage.dao.ResourceDao;
import org.osiam.storage.entities.ResourceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceUpdater {
    private final ResourceDao resourceDao;

    @Autowired
    public ResourceUpdater(ResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    public void update(Resource resource, ResourceEntity resourceEntity) {
        String externalId;
        if (resource.getMeta() != null && resource.getMeta().getAttributes() != null) {
            for (String attribute : resource.getMeta().getAttributes()) {
                if (!attribute.equalsIgnoreCase("externalId")) continue;
                resourceEntity.setExternalId(null);
            }
        }
        if ((externalId = resource.getExternalId()) != null && !externalId.isEmpty()) {
            if (this.resourceDao.isExternalIdAlreadyTaken(externalId, resourceEntity.getId().toString())) {
                throw new ResourceExistsException(String.format("Resource with externalId '%s' already exists", externalId));
            }
            resourceEntity.setExternalId(externalId);
        }
    }
}

