/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.scim.extension;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.validation.Valid;
import org.osiam.scim.extension.ExtensionsConfiguration;
import org.osiam.storage.ExtensionRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="osiam.scim")
public class ExtensionsConfiguration {
    private final ExtensionRepository extensionRepository;
    private final List<Extension> extensions = new ArrayList();

    @Autowired
    public ExtensionsConfiguration(ExtensionRepository extensionRepository) {
        this.extensionRepository = extensionRepository;
    }

    @PostConstruct
    public void createExtensions() {
        this.extensions.stream().filter(extension -> !this.extensionRepository.existsByUrnIgnoreCase(extension.getUrn())).map(Extension::toEntity).forEach(arg_0 -> ((ExtensionRepository)this.extensionRepository).saveAndFlush(arg_0));
    }

    @Valid
    public List<Extension> getExtensions() {
        return this.extensions;
    }
}

