/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.security.authorization;

import com.google.common.base.Splitter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.osiam.resources.scim.User;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

public class OsiamSecurityExpressionMethods {
    private final Authentication authentication;
    private final FilterInvocation filterInvocation;

    public OsiamSecurityExpressionMethods(Authentication authentication, FilterInvocation filterInvocation) {
        this.authentication = authentication;
        this.filterInvocation = filterInvocation;
    }

    public boolean isOwnerOfResource() {
        List pathSegments;
        int uuidIndex;
        String userId;
        block8: {
            if (!(this.authentication.getPrincipal() instanceof User)) {
                return false;
            }
            userId = ((User)this.authentication.getPrincipal()).getId();
            String requestUrl = this.filterInvocation.getRequestUrl();
            if (requestUrl.startsWith("/token/revocation")) {
                uuidIndex = 2;
            } else if (requestUrl.startsWith("/Users")) {
                uuidIndex = 1;
            } else {
                return false;
            }
            try {
                String path = new URI(requestUrl).getPath();
                pathSegments = Splitter.on((char)'/').omitEmptyStrings().trimResults().splitToList((CharSequence)path);
                if (pathSegments.size() >= uuidIndex + 1) break block8;
                return false;
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
        }
        String resourceId = (String)pathSegments.get(uuidIndex);
        return userId.equals(resourceId);
    }
}

