/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.dao;

import org.antlr.v4.runtime.tree.ParseTree;
import org.osiam.resources.exception.ResourceNotFoundException;
import org.osiam.storage.dao.GenericDao;
import org.osiam.storage.dao.ResourceDao;
import org.osiam.storage.dao.SearchResult;
import org.osiam.storage.entities.ResourceEntity;
import org.osiam.storage.entities.UserEntity;
import org.osiam.storage.entities.UserEntity_;
import org.osiam.storage.query.FilterParser;
import org.osiam.storage.query.UserFilterParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserDao
implements GenericDao<UserEntity> {
    private final UserFilterParser filterParser;
    private final ResourceDao resourceDao;

    @Autowired
    public UserDao(UserFilterParser filterParser, ResourceDao resourceDao) {
        this.filterParser = filterParser;
        this.resourceDao = resourceDao;
    }

    public void create(UserEntity userEntity) {
        this.resourceDao.create((ResourceEntity)userEntity);
    }

    public UserEntity getById(String id) {
        try {
            return (UserEntity)this.resourceDao.getById(id, UserEntity.class);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ResourceNotFoundException(String.format("User with id '%s' not found", id), (Throwable)rnfe);
        }
    }

    public long count() {
        return this.resourceDao.count(UserEntity.class);
    }

    public UserEntity getByUsername(String userName) {
        try {
            return (UserEntity)this.resourceDao.getByAttribute(UserEntity_.userName, (Object)userName, UserEntity.class);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ResourceNotFoundException(String.format("User with userName '%s' not found", userName), (Throwable)rnfe);
        }
    }

    public boolean isUserNameAlreadyTaken(String userName) {
        return this.isUserNameAlreadyTaken(userName, null);
    }

    public boolean isUserNameAlreadyTaken(String userName, String id) {
        return this.resourceDao.isUniqueAttributeAlreadyTaken(userName, id, UserEntity_.userName, UserEntity.class);
    }

    public boolean isExternalIdAlreadyTaken(String externalId) {
        return this.resourceDao.isExternalIdAlreadyTaken(externalId);
    }

    public boolean isExternalIdAlreadyTaken(String externalId, String id) {
        return this.resourceDao.isExternalIdAlreadyTaken(externalId, id);
    }

    public UserEntity update(UserEntity entity) {
        return (UserEntity)this.resourceDao.update((ResourceEntity)entity);
    }

    public void delete(String id) {
        try {
            this.resourceDao.delete(id);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ResourceNotFoundException(String.format("User with id '%s' not found", id), (Throwable)rnfe);
        }
    }

    public SearchResult<UserEntity> search(ParseTree filterTree, String sortBy, String sortOrder, int count, int startIndex) {
        return this.resourceDao.search(UserEntity.class, filterTree, count, startIndex, sortBy, sortOrder, (FilterParser)this.filterParser);
    }
}

