/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.helper;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberPadder {
    private static final String OFFSET = "100000000000000000000";
    private static final BigInteger BIG_OFFSET = new BigInteger("100000000000000000000");
    private static final int PAD_LENGTH = "100000000000000000000".length();

    public String pad(String value) {
        String integralPart = value;
        String fractionalPart = "";
        if (value.contains(".")) {
            int indexOfDecimalSeparator = value.indexOf(46);
            integralPart = value.substring(0, indexOfDecimalSeparator);
            fractionalPart = value.substring(indexOfDecimalSeparator);
        }
        if (integralPart.length() > PAD_LENGTH + integralPart.indexOf(45)) {
            throw new IllegalArgumentException("The given value has more than " + (PAD_LENGTH - 1) + " digits.");
        }
        try {
            integralPart = new BigInteger(integralPart).add(BIG_OFFSET).toString();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Unable to parse a number from " + value);
        }
        integralPart = Strings.padStart((String)integralPart, (int)PAD_LENGTH, (char)'0');
        return String.valueOf(integralPart) + fractionalPart;
    }

    public String unpad(String value) {
        BigDecimal decimalValue = new BigDecimal(value);
        BigDecimal returnDecimalValue = new BigDecimal(decimalValue.toBigInteger().subtract(BIG_OFFSET));
        BigDecimal signum = new BigDecimal(returnDecimalValue.signum());
        BigDecimal fractionalPart = decimalValue.remainder(BigDecimal.ONE).multiply(signum);
        returnDecimalValue = returnDecimalValue.add(fractionalPart);
        return returnDecimalValue.toString();
    }
}

