/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.query;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.antlr.v4.runtime.tree.ParseTree;
import org.osiam.resources.exception.InvalidFilterException;
import org.osiam.storage.entities.ResourceEntity;
import org.osiam.storage.query.EvalVisitor;
import org.osiam.storage.query.FilterChain;
import org.osiam.storage.query.FilterConstraint;
import org.osiam.storage.query.FilterExpression;
import org.osiam.storage.query.QueryField;

public abstract class FilterParser<T extends ResourceEntity> {
    @PersistenceContext
    protected EntityManager entityManager;

    public Predicate createPredicateAndJoin(ParseTree filterTree, Root<T> root) {
        EvalVisitor visitor = new EvalVisitor(this, root);
        return (Predicate)visitor.visit(filterTree);
    }

    public Expression<?> createSortByField(String sortBy, Root<T> root) {
        QueryField filterField = this.getFilterField(sortBy);
        if (filterField == null) {
            throw new InvalidFilterException("Sorting by " + sortBy + " is not suported.");
        }
        return filterField.createSortByField(root, this.entityManager.getCriteriaBuilder());
    }

    public abstract FilterExpression<T> createFilterExpression(String var1, FilterConstraint var2, String var3);

    protected abstract QueryField<T> getFilterField(String var1);

    protected abstract FilterChain<T> createFilterChain(FilterExpression<T> var1);
}

