/*
 * Decompiled with CFR 0.152.
 */
package pl.joegreen.lambdaFromString;

import java.lang.reflect.Method;
import pl.joegreen.lambdaFromString.HelperClassSourceProvider;
import pl.joegreen.lambdaFromString.LambdaCreationException;
import pl.joegreen.lambdaFromString.LambdaCreationRuntimeException;
import pl.joegreen.lambdaFromString.LambdaFactoryConfiguration;
import pl.joegreen.lambdaFromString.TypeReference;
import pl.joegreen.lambdaFromString.classFactory.ClassCompilationException;

public class LambdaFactory {
    protected final LambdaFactoryConfiguration configuration;

    public static LambdaFactory get() {
        return new LambdaFactory(LambdaFactoryConfiguration.get());
    }

    public static LambdaFactory get(LambdaFactoryConfiguration configuration) {
        return new LambdaFactory(configuration);
    }

    private LambdaFactory(LambdaFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public <T> T createLambda(String code, TypeReference<T> typeReference) throws LambdaCreationException {
        HelperClassSourceProvider helperProvider = this.configuration.getDefaultHelperClassSourceProvider();
        String helperClassSource = helperProvider.getHelperClassSource(typeReference.toString(), code, this.configuration.getImports(), this.configuration.getStaticImports());
        try {
            Class<?> helperClass = this.configuration.getClassFactory().createClass(helperProvider.getHelperClassName(), helperClassSource);
            Method lambdaReturningMethod = helperClass.getMethod(helperProvider.getLambdaReturningMethodName(), new Class[0]);
            Object lambda = lambdaReturningMethod.invoke(null, new Object[0]);
            return (T)lambda;
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new LambdaCreationException(e);
        }
        catch (ClassCompilationException classCompilationException) {
            throw new LambdaCreationException(classCompilationException);
        }
    }

    public <T> T createLambdaUnchecked(String code, TypeReference<T> type) {
        try {
            return this.createLambda(code, type);
        }
        catch (LambdaCreationException e) {
            throw new LambdaCreationRuntimeException(e);
        }
    }
}

