/*
 * Decompiled with CFR 0.152.
 */
package pl.joegreen.lambdaFromString;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.joegreen.lambdaFromString.DefaultHelperClassSourceProvider;
import pl.joegreen.lambdaFromString.HelperClassSourceProvider;
import pl.joegreen.lambdaFromString.classFactory.ClassFactory;
import pl.joegreen.lambdaFromString.classFactory.DefaultClassFactory;

public class LambdaFactoryConfiguration {
    private HelperClassSourceProvider helperClassSourceProvider = new DefaultHelperClassSourceProvider();
    private ClassFactory classFactory = new DefaultClassFactory();
    private List<String> staticImports = Collections.unmodifiableList(new ArrayList());
    private List<String> imports = Collections.unmodifiableList(new ArrayList());

    public static LambdaFactoryConfiguration get() {
        return new LambdaFactoryConfiguration();
    }

    private LambdaFactoryConfiguration() {
    }

    private LambdaFactoryConfiguration copy() {
        return new LambdaFactoryConfiguration().setClassFactory(this.classFactory).setDefaultHelperClassSourceProvider(this.helperClassSourceProvider).setImports(this.imports).setStaticImports(this.staticImports);
    }

    public HelperClassSourceProvider getDefaultHelperClassSourceProvider() {
        return this.helperClassSourceProvider;
    }

    public ClassFactory getClassFactory() {
        return this.classFactory;
    }

    public List<String> getStaticImports() {
        return this.staticImports;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public LambdaFactoryConfiguration withClassFactory(ClassFactory classFactory) {
        return this.copy().setClassFactory(classFactory);
    }

    public LambdaFactoryConfiguration withHelperClassSourceCreator(HelperClassSourceProvider creator) {
        return this.copy().setDefaultHelperClassSourceProvider(creator);
    }

    public LambdaFactoryConfiguration withImports(String ... newImports) {
        return this.copy().setImports(LambdaFactoryConfiguration.listWithNewElements(this.imports, newImports));
    }

    public LambdaFactoryConfiguration withImports(Class<?> ... newImports) {
        String[] stringImports = (String[])Arrays.stream(newImports).map(Class::getCanonicalName).toArray(String[]::new);
        return this.withImports(stringImports);
    }

    public LambdaFactoryConfiguration withStaticImports(String ... newStaticImports) {
        return this.copy().setStaticImports(LambdaFactoryConfiguration.listWithNewElements(this.staticImports, newStaticImports));
    }

    private LambdaFactoryConfiguration setClassFactory(ClassFactory classFactory) {
        this.classFactory = classFactory;
        return this;
    }

    private LambdaFactoryConfiguration setStaticImports(List<String> staticImports) {
        this.staticImports = staticImports;
        return this;
    }

    private LambdaFactoryConfiguration setImports(List<String> imports) {
        this.imports = imports;
        return this;
    }

    private LambdaFactoryConfiguration setDefaultHelperClassSourceProvider(HelperClassSourceProvider helperClassSourceProvider) {
        this.helperClassSourceProvider = helperClassSourceProvider;
        return this;
    }

    private static <T> List<T> listWithNewElements(List<T> oldList, T ... newElements) {
        return Collections.unmodifiableList(Stream.concat(oldList.stream(), Arrays.stream(newElements)).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaFactoryConfiguration that = (LambdaFactoryConfiguration)o;
        if (!this.helperClassSourceProvider.equals(that.helperClassSourceProvider)) {
            return false;
        }
        if (!this.classFactory.equals(that.classFactory)) {
            return false;
        }
        if (!this.staticImports.equals(that.staticImports)) {
            return false;
        }
        return this.imports.equals(that.imports);
    }

    public int hashCode() {
        int result = this.helperClassSourceProvider.hashCode();
        result = 31 * result + this.classFactory.hashCode();
        result = 31 * result + this.staticImports.hashCode();
        result = 31 * result + this.imports.hashCode();
        return result;
    }
}

