/*
 * Decompiled with CFR 0.152.
 */
package pl.joegreen.lambdaFromString.classFactory;

import java.util.Collections;
import java.util.Map;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import pl.joegreen.lambdaFromString.classFactory.ClassCompilationException;
import pl.joegreen.lambdaFromString.classFactory.ClassFactory;
import pl.joegreen.lambdaFromString.classFactory.ClassSourceJavaObject;
import pl.joegreen.lambdaFromString.classFactory.CompilationDetails;
import pl.joegreen.lambdaFromString.classFactory.CompiledClassJavaObject;
import pl.joegreen.lambdaFromString.classFactory.InMemoryClassLoader;
import pl.joegreen.lambdaFromString.classFactory.InMemoryFileManager;

public class DefaultClassFactory
implements ClassFactory {
    @Override
    public Class<?> createClass(String fullClassName, String sourceCode) throws ClassCompilationException {
        try {
            JavaCompiler compiler = this.findJavaCompiler();
            Map<String, CompiledClassJavaObject> compiledClassesBytes = this.compileClasses(compiler, fullClassName, sourceCode);
            return this.loadClass(fullClassName, compiledClassesBytes);
        }
        catch (ClassNotFoundException | RuntimeException | CannotFindJavaCompilerException e) {
            throw new ClassCompilationException(e);
        }
    }

    protected Class<?> loadClass(String fullClassName, Map<String, CompiledClassJavaObject> compiledClassesBytes) throws ClassNotFoundException {
        return new InMemoryClassLoader(compiledClassesBytes).loadClass(fullClassName);
    }

    protected Map<String, CompiledClassJavaObject> compileClasses(JavaCompiler compiler, String fullClassName, String sourceCode) throws ClassCompilationException {
        ClassSourceJavaObject classSourceObject = new ClassSourceJavaObject(fullClassName, sourceCode);
        try (InMemoryFileManager stdFileManager = new InMemoryFileManager(compiler.getStandardFileManager(null, null, null));){
            DiagnosticCollector diagnosticsCollector = new DiagnosticCollector();
            JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, stdFileManager, diagnosticsCollector, Collections.emptyList(), null, Collections.singletonList(classSourceObject));
            boolean status = compilationTask.call();
            if (!status) {
                throw new ClassCompilationException(new CompilationDetails(fullClassName, sourceCode, diagnosticsCollector.getDiagnostics()));
            }
            Map<String, CompiledClassJavaObject> map = stdFileManager.getClasses();
            return map;
        }
    }

    private JavaCompiler findJavaCompiler() throws CannotFindJavaCompilerException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new CannotFindJavaCompilerException();
        }
        return compiler;
    }

    private static class CannotFindJavaCompilerException
    extends Exception {
        CannotFindJavaCompilerException() {
            super("ToolProvider.getSystemJavaCompiler() returned null - please check your JDK version and/or tools.jar availability.");
        }
    }
}

