/*
 * Decompiled with CFR 0.152.
 */
package pl.joegreen.lambdaFromString.classFactory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import pl.joegreen.lambdaFromString.classFactory.CompiledClassJavaObject;

class InMemoryFileManager
extends ForwardingJavaFileManager<JavaFileManager>
implements JavaFileManager {
    private Map<String, CompiledClassJavaObject> classes = new HashMap<String, CompiledClassJavaObject>();

    protected InMemoryFileManager(JavaFileManager fileManager) {
        super(fileManager);
    }

    public Map<String, CompiledClassJavaObject> getClasses() {
        return new HashMap<String, CompiledClassJavaObject>(this.classes);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            this.classes.putIfAbsent(className, new CompiledClassJavaObject(className));
            return this.classes.get(className);
        }
        throw new IOException(this.getClass().getSimpleName() + " cannot open files for writing. " + "Only .class output is supported and stored in memory.");
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

