/*
 * Decompiled with CFR 0.152.
 */
package pl.joegreen.lambdaFromString;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import javax.tools.JavaCompiler;
import pl.joegreen.lambdaFromString.HelperClassSourceProvider;
import pl.joegreen.lambdaFromString.JavaCompilerNotFoundException;
import pl.joegreen.lambdaFromString.JavaCompilerProvider;
import pl.joegreen.lambdaFromString.LambdaCreationException;
import pl.joegreen.lambdaFromString.LambdaCreationRuntimeException;
import pl.joegreen.lambdaFromString.LambdaFactoryConfiguration;
import pl.joegreen.lambdaFromString.TypeReference;
import pl.joegreen.lambdaFromString.classFactory.ClassCompilationException;
import pl.joegreen.lambdaFromString.classFactory.ClassFactory;

public class LambdaFactory {
    protected static Optional<JavaCompiler> DEFAULT_COMPILER = JavaCompilerProvider.findDefaultJavaCompiler();
    private final HelperClassSourceProvider helperProvider;
    private final ClassFactory classFactory;
    private final JavaCompiler javaCompiler;
    private final List<String> imports;
    private final List<String> staticImports;

    public static LambdaFactory get() {
        return LambdaFactory.get(LambdaFactoryConfiguration.get());
    }

    public static LambdaFactory get(LambdaFactoryConfiguration configuration) {
        JavaCompiler compiler = LambdaFactory.getConfiguredOrDefaultCompiler(configuration);
        return new LambdaFactory(configuration.getDefaultHelperClassSourceProvider(), configuration.getClassFactory(), compiler, configuration.getImports(), configuration.getStaticImports());
    }

    private static JavaCompiler getConfiguredOrDefaultCompiler(LambdaFactoryConfiguration configuration) {
        return configuration.getJavaCompiler().orElse(DEFAULT_COMPILER.orElseThrow(JavaCompilerNotFoundException::new));
    }

    private LambdaFactory(HelperClassSourceProvider helperProvider, ClassFactory classFactory, JavaCompiler javaCompiler, List<String> imports, List<String> staticImports) {
        this.helperProvider = helperProvider;
        this.classFactory = classFactory;
        this.javaCompiler = javaCompiler;
        this.imports = imports;
        this.staticImports = staticImports;
    }

    public <T> T createLambda(String code, TypeReference<T> typeReference) throws LambdaCreationException {
        String helperClassSource = this.helperProvider.getHelperClassSource(typeReference.toString(), code, this.imports, this.staticImports);
        try {
            Class<?> helperClass = this.classFactory.createClass(this.helperProvider.getHelperClassName(), helperClassSource, this.javaCompiler);
            Method lambdaReturningMethod = helperClass.getMethod(this.helperProvider.getLambdaReturningMethodName(), new Class[0]);
            Object lambda = lambdaReturningMethod.invoke(null, new Object[0]);
            return (T)lambda;
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new LambdaCreationException(e);
        }
        catch (ClassCompilationException classCompilationException) {
            throw new LambdaCreationException(classCompilationException);
        }
    }

    public <T> T createLambdaUnchecked(String code, TypeReference<T> type) {
        try {
            return this.createLambda(code, type);
        }
        catch (LambdaCreationException e) {
            throw new LambdaCreationRuntimeException(e);
        }
    }
}

