/*
 * Decompiled with CFR 0.152.
 */
package pl.joegreen.lambdaFromString;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import javax.tools.JavaCompiler;
import pl.joegreen.lambdaFromString.HelperClassSourceProvider;
import pl.joegreen.lambdaFromString.JavaCompilerNotFoundException;
import pl.joegreen.lambdaFromString.LambdaCreationException;
import pl.joegreen.lambdaFromString.LambdaCreationRuntimeException;
import pl.joegreen.lambdaFromString.LambdaFactoryConfiguration;
import pl.joegreen.lambdaFromString.TypeReference;
import pl.joegreen.lambdaFromString.classFactory.ClassCompilationException;
import pl.joegreen.lambdaFromString.classFactory.ClassFactory;

public class LambdaFactory {
    private final HelperClassSourceProvider helperProvider;
    private final ClassFactory classFactory;
    private final JavaCompiler javaCompiler;
    private final List<String> imports;
    private final List<String> staticImports;
    private final String compilationClassPath;
    private final ClassLoader parentClassLoader;
    private final int javaVersion;
    private final List<String> compilerArguments;

    public static LambdaFactory get() {
        return LambdaFactory.get(LambdaFactoryConfiguration.get());
    }

    public static LambdaFactory get(LambdaFactoryConfiguration configuration) {
        JavaCompiler compiler = Optional.ofNullable(configuration.getJavaCompiler()).orElseThrow(JavaCompilerNotFoundException::new);
        return new LambdaFactory(configuration.getDefaultHelperClassSourceProvider(), configuration.getClassFactory(), compiler, configuration.getImports(), configuration.getStaticImports(), configuration.getCompilationClassPath(), configuration.getParentClassLoader(), configuration.getCompilerArguments(), configuration.getJavaVersion());
    }

    private LambdaFactory(HelperClassSourceProvider helperProvider, ClassFactory classFactory, JavaCompiler javaCompiler, List<String> imports, List<String> staticImports, String compilationClassPath, ClassLoader parentClassLoader, List<String> compilerArguments, int javaVersion) {
        this.helperProvider = helperProvider;
        this.classFactory = classFactory;
        this.javaCompiler = javaCompiler;
        this.imports = imports;
        this.staticImports = staticImports;
        this.compilationClassPath = compilationClassPath;
        this.parentClassLoader = parentClassLoader;
        this.compilerArguments = compilerArguments;
        this.javaVersion = javaVersion;
    }

    public <T> T createLambda(String code, TypeReference<T> typeReference) throws LambdaCreationException {
        String helperClassSource = this.helperProvider.getHelperClassSource(typeReference.toString(), code, this.imports, this.staticImports);
        try {
            Class<?> helperClass = this.classFactory.createClass(this.helperProvider.getHelperClassName(), helperClassSource, this.javaCompiler, this.javaVersion, this.compilationClassPath, this.compilerArguments, this.parentClassLoader);
            Method lambdaReturningMethod = helperClass.getMethod(this.helperProvider.getLambdaReturningMethodName(), new Class[0]);
            Object lambda = lambdaReturningMethod.invoke(null, new Object[0]);
            return (T)lambda;
        }
        catch (NoClassDefFoundError | ReflectiveOperationException | RuntimeException e) {
            throw new LambdaCreationException(e);
        }
        catch (ClassCompilationException classCompilationException) {
            throw new LambdaCreationException(classCompilationException);
        }
    }

    public <T> T createLambdaUnchecked(String code, TypeReference<T> type) {
        try {
            return this.createLambda(code, type);
        }
        catch (LambdaCreationException e) {
            throw new LambdaCreationRuntimeException(e);
        }
    }
}

