/*
 * Decompiled with CFR 0.152.
 */
package pl.joegreen.lambdaFromString.classFactory;

import java.util.Map;
import pl.joegreen.lambdaFromString.classFactory.CompiledClassJavaObject;

class InMemoryClassLoader
extends ClassLoader {
    private final Map<String, CompiledClassJavaObject> classes;

    public InMemoryClassLoader(Map<String, CompiledClassJavaObject> classes, ClassLoader parentClassLoader) {
        super(parentClassLoader);
        this.classes = classes;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.findClass(name);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.classes.containsKey(name)) {
            byte[] classBytes = this.classes.get(name).getBytes();
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        throw new ClassNotFoundException("Class " + name + " could not be found in the in-memory collection of compiled classes or in the parent class loader.");
    }
}

