/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.stake;

import software.sava.core.accounts.PublicKey;
import software.sava.core.borsh.Borsh;
import software.sava.core.encoding.ByteUtil;
import software.sava.solana.programs.stake.StakeStatus;

public record ValidatorStakeInfo(long activeStakeLamports, long transientStakeLamports, long lastUpdateEpoch, long transientSeedSuffix, int unused, int validatorSeedSuffix, StakeStatus podStakeStatus, PublicKey voteAccountAddress) implements Borsh
{
    public static int BYTES = 73;

    public static ValidatorStakeInfo read(byte[] data, int offset) {
        long activeStakeLamports = ByteUtil.getInt64LE((byte[])data, (int)offset);
        long transientStakeLamports = ByteUtil.getInt64LE((byte[])data, (int)(offset += 8));
        long lastUpdateEpoch = ByteUtil.getInt64LE((byte[])data, (int)(offset += 8));
        long transientSeedSuffix = ByteUtil.getInt64LE((byte[])data, (int)(offset += 8));
        int unused = ByteUtil.getInt32LE((byte[])data, (int)(offset += 8));
        int validatorSeedSuffix = ByteUtil.getInt32LE((byte[])data, (int)(offset += 4));
        StakeStatus podStakeStatus = StakeStatus.values()[data[offset += 4] & 0xFF];
        PublicKey voteAccountAddress = PublicKey.readPubKey((byte[])data, (int)(++offset));
        return new ValidatorStakeInfo(activeStakeLamports, transientStakeLamports, lastUpdateEpoch, transientSeedSuffix, unused, validatorSeedSuffix, podStakeStatus, voteAccountAddress);
    }

    public int write(byte[] data, int offset) {
        ByteUtil.putInt64LE((byte[])data, (int)offset, (long)this.activeStakeLamports);
        int i = offset + 8;
        ByteUtil.putInt64LE((byte[])data, (int)i, (long)this.transientStakeLamports);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)this.lastUpdateEpoch);
        ByteUtil.putInt64LE((byte[])data, (int)(i += 8), (long)this.transientSeedSuffix);
        ByteUtil.putInt32LE((byte[])data, (int)(i += 8), (int)this.unused);
        ByteUtil.putInt32LE((byte[])data, (int)(i += 4), (int)this.validatorSeedSuffix);
        data[i += 4] = (byte)this.podStakeStatus.ordinal();
        this.voteAccountAddress.write(data, ++i);
        return i + 32;
    }

    public int l() {
        return BYTES;
    }
}

