/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.stakepool;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.tx.Instruction;
import software.sava.solana.programs.clients.NativeProgramAccountClient;
import software.sava.solana.programs.stakepool.StakePoolAccounts;
import software.sava.solana.programs.stakepool.StakePoolProgram;
import software.sava.solana.programs.stakepool.StakePoolProgramClient;
import software.sava.solana.programs.stakepool.StakePoolState;

final class StakePoolProgramClientImpl
implements StakePoolProgramClient {
    private final NativeProgramAccountClient nativeProgramClient;
    private final SolanaAccounts accounts;
    private final StakePoolAccounts stakePoolAccounts;
    private final PublicKey owner;

    StakePoolProgramClientImpl(NativeProgramAccountClient nativeProgramClient, StakePoolAccounts stakePoolAccounts) {
        this.nativeProgramClient = nativeProgramClient;
        this.accounts = nativeProgramClient.solanaAccounts();
        this.stakePoolAccounts = stakePoolAccounts;
        this.owner = nativeProgramClient.ownerPublicKey();
    }

    @Override
    public NativeProgramAccountClient nativeProgramAccountClient() {
        return this.nativeProgramClient;
    }

    @Override
    public SolanaAccounts solanaAccounts() {
        return this.accounts;
    }

    @Override
    public StakePoolAccounts stakePoolAccounts() {
        return this.stakePoolAccounts;
    }

    @Override
    public PublicKey ownerPublicKey() {
        return this.owner;
    }

    @Override
    public Instruction depositSol(PublicKey stakePoolProgram, StakePoolState stakePoolState, PublicKey poolTokenATA, long lamportsIn) {
        return StakePoolProgram.depositSol(this.accounts, AccountMeta.createInvoked((PublicKey)stakePoolProgram), stakePoolState.address(), stakePoolState.reserveStake(), this.owner, poolTokenATA, stakePoolState.managerFeeAccount(), poolTokenATA, stakePoolState.poolMint(), stakePoolState.tokenProgramId(), lamportsIn);
    }

    @Override
    public Instruction depositSolWithSlippage(PublicKey stakePoolProgram, StakePoolState stakePoolState, PublicKey poolTokenATA, long lamportsIn, long minimumPoolTokensOut) {
        return StakePoolProgram.depositSolWithSlippage(this.accounts, AccountMeta.createInvoked((PublicKey)stakePoolProgram), stakePoolState.address(), stakePoolState.reserveStake(), this.owner, poolTokenATA, stakePoolState.managerFeeAccount(), poolTokenATA, stakePoolState.poolMint(), stakePoolState.tokenProgramId(), lamportsIn, minimumPoolTokensOut);
    }

    @Override
    public Instruction depositStake(PublicKey stakePoolProgram, StakePoolState stakePoolState, PublicKey depositStakeAccount, PublicKey validatorStakeAccount, PublicKey poolTokenATA) {
        return StakePoolProgram.depositStake(this.accounts, AccountMeta.createInvoked((PublicKey)stakePoolProgram), stakePoolState.address(), stakePoolState.validatorList(), this.owner, depositStakeAccount, validatorStakeAccount, stakePoolState.reserveStake(), poolTokenATA, stakePoolState.managerFeeAccount(), poolTokenATA, stakePoolState.poolMint(), stakePoolState.tokenProgramId());
    }

    @Override
    public Instruction depositStakeWithSlippage(PublicKey stakePoolProgram, StakePoolState stakePoolState, PublicKey depositStakeAccount, PublicKey validatorStakeAccount, PublicKey poolTokenATA, long minimumPoolTokensOut) {
        return StakePoolProgram.depositStakeWithSlippage(this.accounts, AccountMeta.createInvoked((PublicKey)stakePoolProgram), stakePoolState.address(), stakePoolState.validatorList(), this.owner, depositStakeAccount, validatorStakeAccount, stakePoolState.reserveStake(), poolTokenATA, stakePoolState.managerFeeAccount(), poolTokenATA, stakePoolState.poolMint(), stakePoolState.tokenProgramId(), minimumPoolTokensOut);
    }

    @Override
    public Instruction withdrawSolWithSlippage(PublicKey stakePoolProgram, StakePoolState stakePoolState, PublicKey poolTokenATA, long poolTokenAmount, long lamportsOut) {
        return StakePoolProgram.withdrawSolWithSlippage(this.accounts, AccountMeta.createInvoked((PublicKey)stakePoolProgram), stakePoolState.address(), this.owner, poolTokenATA, stakePoolState.reserveStake(), this.owner, stakePoolState.managerFeeAccount(), stakePoolState.poolMint(), stakePoolState.tokenProgramId(), poolTokenAmount, lamportsOut);
    }

    @Override
    public Instruction withdrawSol(PublicKey stakePoolProgram, StakePoolState stakePoolState, PublicKey poolTokenATA, long poolTokenAmount) {
        return StakePoolProgram.withdrawSol(this.accounts, AccountMeta.createInvoked((PublicKey)stakePoolProgram), stakePoolState.address(), this.owner, poolTokenATA, stakePoolState.reserveStake(), this.owner, stakePoolState.managerFeeAccount(), stakePoolState.poolMint(), stakePoolState.tokenProgramId(), poolTokenAmount);
    }

    @Override
    public Instruction withdrawStakeWithSlippage(PublicKey poolProgram, StakePoolState stakePoolState, PublicKey validatorOrReserveStakeAccount, PublicKey uninitializedStakeAccount, PublicKey stakeAccountWithdrawalAuthority, PublicKey poolTokenATA, long poolTokenAmount, long lamportsOut) {
        return StakePoolProgram.withdrawStakeWithSlippage(this.accounts, AccountMeta.createInvoked((PublicKey)poolProgram), stakePoolState.address(), stakePoolState.validatorList(), validatorOrReserveStakeAccount, uninitializedStakeAccount, stakeAccountWithdrawalAuthority, this.owner, poolTokenATA, stakePoolState.managerFeeAccount(), stakePoolState.poolMint(), stakePoolState.tokenProgramId(), poolTokenAmount, lamportsOut);
    }

    @Override
    public Instruction withdrawStake(PublicKey poolProgram, StakePoolState stakePoolState, PublicKey validatorOrReserveStakeAccount, PublicKey uninitializedStakeAccount, PublicKey stakeAccountWithdrawalAuthority, PublicKey poolTokenATA, long poolTokenAmount) {
        return StakePoolProgram.withdrawStake(this.accounts, AccountMeta.createInvoked((PublicKey)poolProgram), stakePoolState.address(), stakePoolState.validatorList(), validatorOrReserveStakeAccount, uninitializedStakeAccount, stakeAccountWithdrawalAuthority, this.ownerPublicKey(), poolTokenATA, stakePoolState.managerFeeAccount(), stakePoolState.poolMint(), stakePoolState.tokenProgramId(), poolTokenAmount);
    }
}

