/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.token;

import java.util.Arrays;
import java.util.List;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;

public final class TokenProgram {
    private static byte[] initializeMintData(TokenInstruction tokenInstruction, int decimals, PublicKey mintAuthority, PublicKey freezeAuthority) {
        byte[] data;
        if (freezeAuthority == null) {
            data = new byte[35];
            data[34] = 0;
        } else {
            data = new byte[67];
            data[34] = 1;
            freezeAuthority.write(data, 35);
        }
        data[0] = tokenInstruction.discriminator;
        data[1] = (byte)(decimals & 0xFF);
        mintAuthority.write(data, 2);
        return data;
    }

    public static Instruction initializeMint(AccountMeta invokedTokenProgram, SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey mintAuthority, PublicKey freezeAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)mint), solanaAccounts.readRentSysVar());
        byte[] data = TokenProgram.initializeMintData(TokenInstruction.InitializeMint, decimals, mintAuthority, freezeAuthority);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction initializeMint(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey mintAuthority, PublicKey freezeAuthority) {
        return TokenProgram.initializeMint(solanaAccounts.invokedTokenProgram(), solanaAccounts, mint, decimals, mintAuthority, freezeAuthority);
    }

    public static Instruction initializeMint2(AccountMeta invokedTokenProgram, PublicKey mint, int decimals, PublicKey mintAuthority, PublicKey freezeAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)mint));
        byte[] data = TokenProgram.initializeMintData(TokenInstruction.InitializeMint2, decimals, mintAuthority, freezeAuthority);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction initializeMint2(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey mintAuthority, PublicKey freezeAuthority) {
        return TokenProgram.initializeMint2(solanaAccounts.invokedTokenProgram(), mint, decimals, mintAuthority, freezeAuthority);
    }

    public static Instruction initializeAccount(AccountMeta invokedTokenProgram, SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey owner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)account), AccountMeta.createRead((PublicKey)mint), AccountMeta.createRead((PublicKey)owner), solanaAccounts.readRentSysVar());
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])TokenInstruction.InitializeAccount.discriminatorBytes);
    }

    public static Instruction initializeAccount(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey owner) {
        return TokenProgram.initializeAccount(solanaAccounts.invokedTokenProgram(), solanaAccounts, account, mint, owner);
    }

    public static Instruction initializeAccount2(AccountMeta invokedTokenProgram, SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey owner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)account), AccountMeta.createRead((PublicKey)mint), solanaAccounts.readRentSysVar());
        byte[] data = new byte[33];
        data[0] = TokenInstruction.InitializeAccount2.discriminator;
        owner.write(data, 1);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction initializeAccount2(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey owner) {
        return TokenProgram.initializeAccount2(solanaAccounts.invokedTokenProgram(), solanaAccounts, account, mint, owner);
    }

    public static Instruction initializeAccount3(AccountMeta invokedTokenProgram, PublicKey account, PublicKey mint, PublicKey owner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)account), AccountMeta.createRead((PublicKey)mint));
        byte[] data = new byte[33];
        data[0] = TokenInstruction.InitializeAccount3.discriminator;
        owner.write(data, 1);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction initializeAccount3(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey owner) {
        return TokenProgram.initializeAccount3(solanaAccounts.invokedTokenProgram(), account, mint, owner);
    }

    static AccountMeta[] initSigners(int offset, List<PublicKey> signerAccounts) {
        AccountMeta[] keys = new AccountMeta[offset + signerAccounts.size()];
        for (PublicKey signerAccount : signerAccounts) {
            keys[offset++] = AccountMeta.createRead((PublicKey)signerAccount);
        }
        return keys;
    }

    public static Instruction initializeMultisig(AccountMeta invokedTokenProgram, SolanaAccounts solanaAccounts, PublicKey multisigAccount, List<PublicKey> signerAccounts, int requiredSignatures) {
        AccountMeta[] keys = TokenProgram.initSigners(2, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)multisigAccount);
        keys[1] = solanaAccounts.readRentSysVar();
        byte[] data = new byte[]{TokenInstruction.InitializeMultisig.discriminator, (byte)(requiredSignatures & 0xFF)};
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, Arrays.asList(keys), (byte[])data);
    }

    public static Instruction initializeMultisig(SolanaAccounts solanaAccounts, PublicKey multisigAccount, List<PublicKey> signerAccounts, int requiredSignatures) {
        return TokenProgram.initializeMultisig(solanaAccounts.invokedTokenProgram(), solanaAccounts, multisigAccount, signerAccounts, requiredSignatures);
    }

    public static Instruction initializeMultisig2(AccountMeta invokedTokenProgram, PublicKey multisigAccount, List<PublicKey> signerAccounts, int requiredSignatures) {
        AccountMeta[] keys = TokenProgram.initSigners(1, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)multisigAccount);
        byte[] data = new byte[]{TokenInstruction.InitializeMultisig2.discriminator, (byte)(requiredSignatures & 0xFF)};
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, Arrays.asList(keys), (byte[])data);
    }

    private static byte[] amountData(TokenInstruction tokenInstruction, long amount) {
        byte[] data = new byte[9];
        data[0] = tokenInstruction.discriminator;
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)amount);
        return data;
    }

    private static byte[] transferData(long amount) {
        return TokenProgram.amountData(TokenInstruction.Transfer, amount);
    }

    public static Instruction transfer(AccountMeta invokedProgram, PublicKey source, PublicKey destination, long amount, PublicKey owner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)source), AccountMeta.createWrite((PublicKey)destination), AccountMeta.createReadOnlySigner((PublicKey)owner));
        byte[] data = TokenProgram.transferData(amount);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction transferMultisig(AccountMeta invokedProgram, PublicKey source, PublicKey destination, long amount, PublicKey owner, List<PublicKey> signerAccounts) {
        AccountMeta[] keys = TokenProgram.initSigners(3, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)source);
        keys[1] = AccountMeta.createWrite((PublicKey)destination);
        keys[2] = AccountMeta.createRead((PublicKey)owner);
        byte[] data = TokenProgram.transferData(amount);
        return Instruction.createInstruction((AccountMeta)invokedProgram, Arrays.asList(keys), (byte[])data);
    }

    private static byte[] checkedAmountData(TokenInstruction tokenInstruction, long amount, int decimals) {
        byte[] data = new byte[10];
        data[0] = tokenInstruction.discriminator;
        ByteUtil.putInt64LE((byte[])data, (int)1, (long)amount);
        data[9] = (byte)(decimals & 0xFF);
        return data;
    }

    private static byte[] transferCheckedData(long amount, int decimals) {
        return TokenProgram.checkedAmountData(TokenInstruction.TransferChecked, amount, decimals);
    }

    public static Instruction transferChecked(AccountMeta invokedProgram, PublicKey source, PublicKey destination, long amount, int decimals, PublicKey owner, PublicKey tokenMint) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)source), AccountMeta.createRead((PublicKey)tokenMint), AccountMeta.createWrite((PublicKey)destination), AccountMeta.createReadOnlySigner((PublicKey)owner));
        byte[] data = TokenProgram.transferCheckedData(amount, decimals);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction transferCheckedMultisig(AccountMeta invokedProgram, PublicKey source, PublicKey destination, long amount, int decimals, PublicKey owner, PublicKey tokenMint, List<PublicKey> signerAccounts) {
        AccountMeta[] keys = TokenProgram.initSigners(4, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)source);
        keys[1] = AccountMeta.createRead((PublicKey)tokenMint);
        keys[2] = AccountMeta.createWrite((PublicKey)destination);
        keys[3] = AccountMeta.createRead((PublicKey)owner);
        byte[] data = TokenProgram.transferCheckedData(amount, decimals);
        return Instruction.createInstruction((AccountMeta)invokedProgram, Arrays.asList(keys), (byte[])data);
    }

    private static byte[] approveData(long amount) {
        return TokenProgram.amountData(TokenInstruction.Approve, amount);
    }

    public static Instruction approve(AccountMeta invokedTokenProgram, PublicKey sourceAccount, PublicKey delegate, PublicKey owner, long amount) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)sourceAccount), AccountMeta.createRead((PublicKey)delegate), AccountMeta.createReadOnlySigner((PublicKey)owner));
        byte[] data = TokenProgram.approveData(amount);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction approve(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey delegate, PublicKey owner, long amount) {
        return TokenProgram.approve(solanaAccounts.invokedTokenProgram(), sourceAccount, delegate, owner, amount);
    }

    public static Instruction approveMultisig(AccountMeta invokedTokenProgram, PublicKey sourceAccount, PublicKey delegate, PublicKey owner, List<PublicKey> signerAccounts, long amount) {
        AccountMeta[] keys = TokenProgram.initSigners(3, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)sourceAccount);
        keys[1] = AccountMeta.createRead((PublicKey)delegate);
        keys[2] = AccountMeta.createRead((PublicKey)owner);
        byte[] data = TokenProgram.approveData(amount);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, Arrays.asList(keys), (byte[])data);
    }

    public static Instruction approveMultisig(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey delegate, PublicKey owner, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.approveMultisig(solanaAccounts.invokedTokenProgram(), sourceAccount, delegate, owner, signerAccounts, amount);
    }

    private static byte[] approveCheckedData(long amount, int decimals) {
        return TokenProgram.checkedAmountData(TokenInstruction.ApproveChecked, amount, decimals);
    }

    public static Instruction approveChecked(AccountMeta invokedTokenProgram, PublicKey sourceAccount, PublicKey tokenMint, int decimals, PublicKey delegate, PublicKey owner, long amount) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)sourceAccount), AccountMeta.createRead((PublicKey)tokenMint), AccountMeta.createRead((PublicKey)delegate), AccountMeta.createReadOnlySigner((PublicKey)owner));
        byte[] data = TokenProgram.approveCheckedData(amount, decimals);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction approveChecked(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey tokenMint, int decimals, PublicKey delegate, PublicKey owner, long amount) {
        return TokenProgram.approveChecked(solanaAccounts.invokedTokenProgram(), sourceAccount, tokenMint, decimals, delegate, owner, amount);
    }

    public static Instruction approveCheckedMultisig(AccountMeta invokedTokenProgram, PublicKey sourceAccount, PublicKey tokenMint, int decimals, PublicKey delegate, PublicKey owner, List<PublicKey> signerAccounts, long amount) {
        AccountMeta[] keys = TokenProgram.initSigners(4, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)sourceAccount);
        keys[1] = AccountMeta.createRead((PublicKey)tokenMint);
        keys[2] = AccountMeta.createRead((PublicKey)delegate);
        keys[3] = AccountMeta.createRead((PublicKey)owner);
        byte[] data = TokenProgram.approveCheckedData(amount, decimals);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, Arrays.asList(keys), (byte[])data);
    }

    public static Instruction approveCheckedMultisig(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey tokenMint, int decimals, PublicKey delegate, PublicKey owner, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.approveCheckedMultisig(solanaAccounts.invokedTokenProgram(), sourceAccount, tokenMint, decimals, delegate, owner, signerAccounts, amount);
    }

    public static Instruction revoke(AccountMeta invokedTokenProgram, PublicKey sourceAccount, PublicKey owner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)sourceAccount), AccountMeta.createReadOnlySigner((PublicKey)owner));
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])TokenInstruction.Revoke.discriminatorBytes);
    }

    public static Instruction revoke(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey owner) {
        return TokenProgram.revoke(solanaAccounts.invokedTokenProgram(), sourceAccount, owner);
    }

    public static Instruction revokeMultisig(AccountMeta invokedTokenProgram, PublicKey sourceAccount, PublicKey owner, List<PublicKey> signerAccounts) {
        AccountMeta[] keys = TokenProgram.initSigners(2, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)sourceAccount);
        keys[1] = AccountMeta.createRead((PublicKey)owner);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, Arrays.asList(keys), (byte[])TokenInstruction.Revoke.discriminatorBytes);
    }

    public static Instruction revokeMultisig(SolanaAccounts solanaAccounts, PublicKey sourceAccount, PublicKey owner, List<PublicKey> signerAccounts) {
        return TokenProgram.revokeMultisig(solanaAccounts.invokedTokenProgram(), sourceAccount, owner, signerAccounts);
    }

    private static byte[] setAuthorityData(AuthorityType authorityType, PublicKey newAuthority) {
        byte[] data;
        if (newAuthority == null) {
            data = new byte[3];
        } else {
            data = new byte[35];
            data[2] = 1;
            newAuthority.write(data, 3);
        }
        data[0] = TokenInstruction.SetAuthority.discriminator;
        data[1] = (byte)authorityType.ordinal();
        return data;
    }

    public static Instruction setAuthority(AccountMeta invokedTokenProgram, PublicKey account, PublicKey authority, AuthorityType authorityType, PublicKey newAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)account), AccountMeta.createReadOnlySigner((PublicKey)authority));
        byte[] data = TokenProgram.setAuthorityData(authorityType, newAuthority);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction setAuthority(SolanaAccounts solanaAccounts, PublicKey account, PublicKey authority, AuthorityType authorityType, PublicKey newAuthority) {
        return TokenProgram.setAuthority(solanaAccounts.invokedTokenProgram(), account, authority, authorityType, newAuthority);
    }

    public static Instruction setAuthorityMultisig(AccountMeta invokedTokenProgram, PublicKey account, PublicKey owner, List<PublicKey> signerAccounts, AuthorityType authorityType, PublicKey newAuthority) {
        AccountMeta[] keys = TokenProgram.initSigners(2, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)account);
        keys[1] = AccountMeta.createRead((PublicKey)owner);
        byte[] data = TokenProgram.setAuthorityData(authorityType, newAuthority);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, Arrays.asList(keys), (byte[])data);
    }

    public static Instruction setAuthorityMultisig(SolanaAccounts solanaAccounts, PublicKey account, PublicKey owner, List<PublicKey> signerAccounts, AuthorityType authorityType, PublicKey newAuthority) {
        return TokenProgram.setAuthorityMultisig(solanaAccounts.invokedTokenProgram(), account, owner, signerAccounts, authorityType, newAuthority);
    }

    private static byte[] mintToData(long amount) {
        return TokenProgram.amountData(TokenInstruction.MintTo, amount);
    }

    private static List<AccountMeta> mintToKeys(PublicKey mint, PublicKey account, PublicKey authority) {
        return List.of(AccountMeta.createWrite((PublicKey)mint), AccountMeta.createWrite((PublicKey)account), AccountMeta.createReadOnlySigner((PublicKey)authority));
    }

    public static Instruction mintTo(AccountMeta invokedTokenProgram, PublicKey mint, PublicKey account, PublicKey authority, long amount) {
        List<AccountMeta> keys = TokenProgram.mintToKeys(mint, account, authority);
        byte[] data = TokenProgram.mintToData(amount);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction mintTo(SolanaAccounts solanaAccounts, PublicKey mint, PublicKey account, PublicKey authority, long amount) {
        return TokenProgram.mintTo(solanaAccounts.invokedTokenProgram(), mint, account, authority, amount);
    }

    private static List<AccountMeta> mintToMultisigKeys(PublicKey mint, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts) {
        AccountMeta[] keys = TokenProgram.initSigners(3, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)mint);
        keys[1] = AccountMeta.createWrite((PublicKey)account);
        keys[2] = AccountMeta.createRead((PublicKey)authority);
        return Arrays.asList(keys);
    }

    public static Instruction mintToMultisig(AccountMeta invokedTokenProgram, PublicKey mint, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        List<AccountMeta> keys = TokenProgram.mintToMultisigKeys(mint, account, authority, signerAccounts);
        byte[] data = TokenProgram.mintToData(amount);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction mintToMultisig(SolanaAccounts solanaAccounts, PublicKey mint, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.mintToMultisig(solanaAccounts.invokedTokenProgram(), mint, account, authority, signerAccounts, amount);
    }

    private static byte[] mintToCheckedData(long amount, int decimals) {
        return TokenProgram.checkedAmountData(TokenInstruction.MintToChecked, amount, decimals);
    }

    public static Instruction mintToChecked(AccountMeta invokedTokenProgram, PublicKey mint, int decimals, PublicKey account, PublicKey authority, long amount) {
        List<AccountMeta> keys = TokenProgram.mintToKeys(mint, account, authority);
        byte[] data = TokenProgram.mintToCheckedData(amount, decimals);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction mintToChecked(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey account, PublicKey authority, long amount) {
        return TokenProgram.mintToChecked(solanaAccounts.invokedTokenProgram(), mint, decimals, account, authority, amount);
    }

    public static Instruction mintToCheckedMultisig(AccountMeta invokedTokenProgram, PublicKey mint, int decimals, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        List<AccountMeta> keys = TokenProgram.mintToMultisigKeys(mint, account, authority, signerAccounts);
        byte[] data = TokenProgram.mintToCheckedData(amount, decimals);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction mintToCheckedMultisig(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.mintToCheckedMultisig(solanaAccounts.invokedTokenProgram(), mint, decimals, account, authority, signerAccounts, amount);
    }

    private static byte[] burnData(long amount) {
        return TokenProgram.amountData(TokenInstruction.Burn, amount);
    }

    private static List<AccountMeta> burnKeys(PublicKey mint, PublicKey account, PublicKey authority) {
        return List.of(AccountMeta.createWrite((PublicKey)account), AccountMeta.createWrite((PublicKey)mint), AccountMeta.createReadOnlySigner((PublicKey)authority));
    }

    public static Instruction burn(AccountMeta invokedTokenProgram, PublicKey mint, PublicKey account, PublicKey authority, long amount) {
        List<AccountMeta> keys = TokenProgram.burnKeys(mint, account, authority);
        byte[] data = TokenProgram.burnData(amount);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction burn(SolanaAccounts solanaAccounts, PublicKey mint, PublicKey account, PublicKey authority, long amount) {
        return TokenProgram.burn(solanaAccounts.invokedTokenProgram(), mint, account, authority, amount);
    }

    private static List<AccountMeta> burnMultisigKeys(PublicKey mint, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts) {
        AccountMeta[] keys = TokenProgram.initSigners(3, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)account);
        keys[1] = AccountMeta.createWrite((PublicKey)mint);
        keys[2] = AccountMeta.createRead((PublicKey)authority);
        return Arrays.asList(keys);
    }

    public static Instruction burnMultisig(AccountMeta invokedTokenProgram, PublicKey mint, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        List<AccountMeta> keys = TokenProgram.burnMultisigKeys(mint, account, authority, signerAccounts);
        byte[] data = TokenProgram.burnData(amount);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction burnMultisig(SolanaAccounts solanaAccounts, PublicKey mint, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.burnMultisig(solanaAccounts.invokedTokenProgram(), mint, account, authority, signerAccounts, amount);
    }

    private static byte[] burnCheckedData(long amount, int decimals) {
        return TokenProgram.checkedAmountData(TokenInstruction.BurnChecked, amount, decimals);
    }

    public static Instruction burnChecked(AccountMeta invokedTokenProgram, PublicKey mint, int decimals, PublicKey account, PublicKey authority, long amount) {
        List<AccountMeta> keys = TokenProgram.burnKeys(mint, account, authority);
        byte[] data = TokenProgram.burnCheckedData(amount, decimals);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction burnChecked(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey account, PublicKey authority, long amount) {
        return TokenProgram.burnChecked(solanaAccounts.invokedTokenProgram(), mint, decimals, account, authority, amount);
    }

    public static Instruction burnCheckedMultisig(AccountMeta invokedTokenProgram, PublicKey mint, int decimals, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        List<AccountMeta> keys = TokenProgram.burnMultisigKeys(mint, account, authority, signerAccounts);
        byte[] data = TokenProgram.burnCheckedData(amount, decimals);
        return Instruction.createInstruction((AccountMeta)invokedTokenProgram, keys, (byte[])data);
    }

    public static Instruction burnCheckedMultisig(SolanaAccounts solanaAccounts, PublicKey mint, int decimals, PublicKey account, PublicKey authority, List<PublicKey> signerAccounts, long amount) {
        return TokenProgram.burnCheckedMultisig(solanaAccounts.invokedTokenProgram(), mint, decimals, account, authority, signerAccounts, amount);
    }

    public static Instruction closeAccount(AccountMeta invokedProgram, PublicKey tokenAccount, PublicKey lamportDestination, PublicKey owner) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)tokenAccount), AccountMeta.createWrite((PublicKey)lamportDestination), AccountMeta.createReadOnlySigner((PublicKey)owner));
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])TokenInstruction.CloseAccount.discriminatorBytes);
    }

    public static Instruction closeAccount(SolanaAccounts solanaAccounts, PublicKey tokenAccount, PublicKey lamportDestination, PublicKey owner) {
        return TokenProgram.closeAccount(solanaAccounts.invokedSystemProgram(), tokenAccount, lamportDestination, owner);
    }

    public static Instruction closeAccountMultisig(AccountMeta invokedProgram, PublicKey tokenAccount, PublicKey lamportDestination, PublicKey owner, List<PublicKey> signerAccounts) {
        AccountMeta[] keys = TokenProgram.initSigners(3, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)tokenAccount);
        keys[1] = AccountMeta.createWrite((PublicKey)lamportDestination);
        keys[2] = AccountMeta.createRead((PublicKey)owner);
        return Instruction.createInstruction((AccountMeta)invokedProgram, Arrays.asList(keys), (byte[])TokenInstruction.CloseAccount.discriminatorBytes);
    }

    public static Instruction closeAccountMultisig(SolanaAccounts solanaAccounts, PublicKey tokenAccount, PublicKey lamportDestination, PublicKey owner, List<PublicKey> signerAccounts) {
        return TokenProgram.closeAccountMultisig(solanaAccounts.invokedSystemProgram(), tokenAccount, lamportDestination, owner, signerAccounts);
    }

    public static Instruction freezeAccount(AccountMeta invokedProgram, PublicKey account, PublicKey mint, PublicKey freezeAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)account), AccountMeta.createRead((PublicKey)mint), AccountMeta.createReadOnlySigner((PublicKey)freezeAuthority));
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])TokenInstruction.FreezeAccount.discriminatorBytes);
    }

    public static Instruction freezeAccount(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey freezeAuthority) {
        return TokenProgram.freezeAccount(solanaAccounts.invokedSystemProgram(), account, mint, freezeAuthority);
    }

    public static Instruction freezeAccountMultisig(AccountMeta invokedProgram, PublicKey account, PublicKey mint, PublicKey freezeAuthority, List<PublicKey> signerAccounts) {
        AccountMeta[] keys = TokenProgram.initSigners(3, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)account);
        keys[1] = AccountMeta.createRead((PublicKey)mint);
        keys[2] = AccountMeta.createRead((PublicKey)freezeAuthority);
        return Instruction.createInstruction((AccountMeta)invokedProgram, Arrays.asList(keys), (byte[])TokenInstruction.FreezeAccount.discriminatorBytes);
    }

    public static Instruction freezeAccountMultisig(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey freezeAuthority, List<PublicKey> signerAccounts) {
        return TokenProgram.freezeAccountMultisig(solanaAccounts.invokedTokenProgram(), account, mint, freezeAuthority, signerAccounts);
    }

    public static Instruction thawAccount(AccountMeta invokedProgram, PublicKey account, PublicKey mint, PublicKey authority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)account), AccountMeta.createRead((PublicKey)mint), AccountMeta.createReadOnlySigner((PublicKey)authority));
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])TokenInstruction.ThawAccount.discriminatorBytes);
    }

    public static Instruction thawAccount(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey authority) {
        return TokenProgram.thawAccount(solanaAccounts.invokedSystemProgram(), account, mint, authority);
    }

    public static Instruction thawAccountMultisig(AccountMeta invokedProgram, PublicKey account, PublicKey mint, PublicKey authority, List<PublicKey> signerAccounts) {
        AccountMeta[] keys = TokenProgram.initSigners(3, signerAccounts);
        keys[0] = AccountMeta.createWrite((PublicKey)account);
        keys[1] = AccountMeta.createRead((PublicKey)mint);
        keys[2] = AccountMeta.createRead((PublicKey)authority);
        return Instruction.createInstruction((AccountMeta)invokedProgram, Arrays.asList(keys), (byte[])TokenInstruction.ThawAccount.discriminatorBytes);
    }

    public static Instruction thawAccountMultisig(SolanaAccounts solanaAccounts, PublicKey account, PublicKey mint, PublicKey authority, List<PublicKey> signerAccounts) {
        return TokenProgram.thawAccountMultisig(solanaAccounts.invokedTokenProgram(), account, mint, authority, signerAccounts);
    }

    public static Instruction syncNative(AccountMeta invokedProgram, PublicKey solTokenAccount) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)solTokenAccount));
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])TokenInstruction.SyncNative.discriminatorBytes);
    }

    public static Instruction initializeImmutableOwner(AccountMeta invokedProgram, PublicKey account) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)account));
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])TokenInstruction.InitializeImmutableOwner.discriminatorBytes);
    }

    private TokenProgram() {
    }

    public static enum TokenInstruction implements Discriminator
    {
        InitializeMint,
        InitializeAccount,
        InitializeMultisig,
        Transfer,
        Approve,
        Revoke,
        SetAuthority,
        MintTo,
        Burn,
        CloseAccount,
        FreezeAccount,
        ThawAccount,
        TransferChecked,
        ApproveChecked,
        MintToChecked,
        BurnChecked,
        InitializeAccount2,
        SyncNative,
        InitializeAccount3,
        InitializeMultisig2,
        InitializeMint2,
        GetAccountDataSize,
        InitializeImmutableOwner,
        AmountToUiAmount,
        UiAmountToAmount;

        private final byte discriminator = (byte)this.ordinal();
        private final byte[] discriminatorBytes = new byte[]{this.discriminator};

        public byte[] data() {
            return this.discriminatorBytes;
        }

        public int write(byte[] bytes, int i) {
            bytes[i] = (byte)this.ordinal();
            return 1;
        }

        public int length() {
            return 1;
        }
    }

    public static enum AuthorityType {
        MintTokens,
        FreezeAccount,
        AccountOwner,
        CloseAccount;

    }
}

