/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.vote;

import software.sava.core.accounts.PublicKey;
import software.sava.core.serial.Serializable;
import software.sava.solana.programs.serde.SerdeUtil;
import software.sava.solana.programs.vote.VoteAuthorize;

public record VoteAuthorizeCheckedWithSeedArgs(VoteAuthorize authorizationType, PublicKey currentAuthorityDerivedKeyOwner, byte[] currentAuthorityDerivedKeySeed) implements Serializable
{
    public static VoteAuthorizeCheckedWithSeedArgs read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        int i = offset;
        VoteAuthorize authorizationType = VoteAuthorize.read(data, i);
        PublicKey currentAuthorityDerivedKeyOwner = PublicKey.readPubKey((byte[])data, (int)(i += authorizationType.l()));
        byte[] currentAuthorityDerivedKeySeed = SerdeUtil.readString(data, i += 32);
        return new VoteAuthorizeCheckedWithSeedArgs(authorizationType, currentAuthorityDerivedKeyOwner, currentAuthorityDerivedKeySeed);
    }

    public int write(byte[] data, int offset) {
        int i = this.authorizationType.write(data, offset);
        i += this.currentAuthorityDerivedKeyOwner.write(data, i);
        i += SerdeUtil.writeString(this.currentAuthorityDerivedKeySeed, data, i);
        return i - offset;
    }

    public int l() {
        return this.authorizationType.l() + 32 + 8 + this.currentAuthorityDerivedKeySeed.length;
    }
}

