/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.vote;

import software.sava.core.accounts.PublicKey;
import software.sava.core.serial.Serializable;

public record VoteInit(PublicKey nodePubkey, PublicKey authorizedVoter, PublicKey authorizedWithdrawer, int commission) implements Serializable
{
    public static final int BYTES = 97;

    public static VoteInit read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        int i = offset;
        PublicKey nodePubkey = PublicKey.readPubKey((byte[])data, (int)i);
        PublicKey authorizedVoter = PublicKey.readPubKey((byte[])data, (int)(i += 32));
        PublicKey authorizedWithdrawer = PublicKey.readPubKey((byte[])data, (int)(i += 32));
        int commission = data[i += 32] & 0xFF;
        return new VoteInit(nodePubkey, authorizedVoter, authorizedWithdrawer, commission);
    }

    public int write(byte[] data, int offset) {
        int i = offset;
        i += this.nodePubkey.write(data, i);
        i += this.authorizedVoter.write(data, i);
        i += this.authorizedWithdrawer.write(data, i);
        data[i] = (byte)this.commission;
        return i - offset;
    }

    public int l() {
        return 97;
    }
}

