/*
 * Decompiled with CFR 0.152.
 */
package software.sava.solana.programs.vote;

import java.util.List;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccounts;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;
import software.sava.solana.programs.vote.VoteAuthorize;
import software.sava.solana.programs.vote.VoteAuthorizeCheckedWithSeedArgs;
import software.sava.solana.programs.vote.VoteAuthorizeWithSeedArgs;
import software.sava.solana.programs.vote.VoteInit;

public final class VoteProgram {
    public static Instruction initializeAccount(SolanaAccounts solanaAccounts, PublicKey voteAccount, PublicKey validatorIdentity, VoteInit voteInit) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)voteAccount), solanaAccounts.readRentSysVar(), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)validatorIdentity));
        byte[] data = new byte[101];
        int offset = Instructions.InitializeAccount.write(data, 0);
        voteInit.write(data, offset);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedVoteProgram(), keys, (byte[])data);
    }

    public static Instruction authorize(SolanaAccounts solanaAccounts, PublicKey voteAccount, PublicKey currentAuthority, PublicKey newAuthority, VoteAuthorize voteAuthorize) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)voteAccount), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)currentAuthority));
        byte[] data = new byte[36 + voteAuthorize.l()];
        int offset = Instructions.Authorize.write(data, 0);
        offset += newAuthority.write(data, offset);
        voteAuthorize.write(data, offset);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedVoteProgram(), keys, (byte[])data);
    }

    public static Instruction authorizeChecked(SolanaAccounts solanaAccounts, PublicKey voteAccount, PublicKey currentAuthority, PublicKey newAuthority, VoteAuthorize voteAuthorize) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)voteAccount), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)currentAuthority), AccountMeta.createReadOnlySigner((PublicKey)newAuthority));
        byte[] data = new byte[4 + voteAuthorize.l()];
        Instructions.AuthorizeChecked.write(data, 0);
        voteAuthorize.write(data, 4);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedVoteProgram(), keys, (byte[])data);
    }

    public static Instruction authorizeWithSeed(SolanaAccounts solanaAccounts, PublicKey voteAccount, PublicKey baseKey, VoteAuthorizeWithSeedArgs args) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)voteAccount), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)baseKey));
        byte[] data = new byte[4 + args.l()];
        Instructions.AuthorizeWithSeed.write(data, 0);
        args.write(data, 4);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedVoteProgram(), keys, (byte[])data);
    }

    public static Instruction authorizeCheckedWithSeed(SolanaAccounts solanaAccounts, PublicKey voteAccount, PublicKey baseKey, PublicKey newAuthority, VoteAuthorizeCheckedWithSeedArgs args) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)voteAccount), solanaAccounts.readClockSysVar(), AccountMeta.createReadOnlySigner((PublicKey)baseKey), AccountMeta.createReadOnlySigner((PublicKey)newAuthority));
        byte[] data = new byte[4 + args.l()];
        Instructions.AuthorizeCheckedWithSeed.write(data, 0);
        args.write(data, 4);
        return Instruction.createInstruction((AccountMeta)solanaAccounts.invokedVoteProgram(), keys, (byte[])data);
    }

    public static Instruction withdraw(AccountMeta invokedProgram, PublicKey voteAccount, PublicKey recipientAccount, PublicKey withdrawAuthority, long lamports) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)voteAccount), AccountMeta.createWrite((PublicKey)recipientAccount), AccountMeta.createReadOnlySigner((PublicKey)withdrawAuthority));
        byte[] data = new byte[12];
        Instructions.Withdraw.write(data, 0);
        ByteUtil.putInt64LE((byte[])data, (int)4, (long)lamports);
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    public static Instruction updateValidatorIdentity(AccountMeta invokedProgram, PublicKey voteAccount, PublicKey newValidatorIdentity, PublicKey withdrawAuthority) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)voteAccount), AccountMeta.createReadOnlySigner((PublicKey)newValidatorIdentity), AccountMeta.createReadOnlySigner((PublicKey)withdrawAuthority));
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])Instructions.UpdateValidatorIdentity.data());
    }

    public static Instruction updateCommission(AccountMeta invokedProgram, PublicKey voteAccount, PublicKey withdrawAuthority, int commission) {
        List<AccountMeta> keys = List.of(AccountMeta.createWrite((PublicKey)voteAccount), AccountMeta.createReadOnlySigner((PublicKey)withdrawAuthority));
        byte[] data = new byte[5];
        Instructions.UpdateCommission.write(data, 0);
        data[4] = (byte)commission;
        return Instruction.createInstruction((AccountMeta)invokedProgram, keys, (byte[])data);
    }

    private VoteProgram() {
    }

    public static enum Instructions implements Discriminator
    {
        InitializeAccount,
        Authorize,
        Vote,
        Withdraw,
        UpdateValidatorIdentity,
        UpdateCommission,
        VoteSwitch,
        AuthorizeChecked,
        UpdateVoteState,
        UpdateVoteStateSwitch,
        AuthorizeWithSeed,
        AuthorizeCheckedWithSeed,
        CompactUpdateVoteState,
        CompactUpdateVoteStateSwitch,
        TowerSync,
        TowerSyncSwitch;

        private final byte[] data = Discriminator.serializeDiscriminator((Enum)this);

        public byte[] data() {
            return this.data;
        }
    }
}

