/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.modl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import uk.modl.interpreter.Interpreter;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;
import uk.modl.parser.printers.JsonPrinter;
import uk.num.numlib.exc.NumBadRecordException;
import uk.num.numlib.internal.modl.NumLookupRedirect;
import uk.num.numlib.internal.modl.NumQueryRedirect;
import uk.num.numlib.internal.modl.PopulatorResponse;
import uk.num.numlib.internal.module.ModuleConfig;

public class ModlServices {
    private ObjectMapper objectMapper = new ObjectMapper();

    public ModuleConfig interpretModuleConfig(String configTxt) throws NumBadRecordException {
        assert (configTxt != null && configTxt.trim().length() > 0);
        try {
            ModlObject modlObject = Interpreter.interpret((String)configTxt, new ArrayList());
            String configJson = JsonPrinter.printModl((ModlObject)modlObject);
            return (ModuleConfig)this.objectMapper.readValue(configJson, ModuleConfig.class);
        }
        catch (Exception e) {
            throw new NumBadRecordException("Error interpreting module config file.", e);
        }
    }

    public String interpretNumRecord(String numRecord) throws NumBadRecordException, NumQueryRedirect, NumLookupRedirect {
        assert (numRecord != null && numRecord.trim().length() > 0);
        try {
            ModlObject modlObject = Interpreter.interpret((String)numRecord, new ArrayList());
            this.checkForRedirection(modlObject);
            return JsonPrinter.printModl((ModlObject)modlObject);
        }
        catch (Exception e) {
            throw new NumBadRecordException("Error interpreting NUM record.", e);
        }
    }

    private void checkForRedirection(ModlObject modlObject) throws NumQueryRedirect, NumLookupRedirect {
        if (modlObject.getStructures() != null) {
            for (ModlObject.Structure structure : modlObject.getStructures()) {
                this.findRedirect((ModlValue)structure);
            }
        }
    }

    private void findRedirect(ModlValue structure) throws NumQueryRedirect, NumLookupRedirect {
        if (structure instanceof ModlObject.Pair) {
            Object value;
            ModlObject.Pair pair = (ModlObject.Pair)structure;
            if ("q_".equals(pair.getKey().string) && (value = pair.getValue()) instanceof ModlObject.String) {
                ModlObject.String str = (ModlObject.String)value;
                throw new NumQueryRedirect(str.string);
            }
            if ("l_".equals(pair.getKey().string) && (value = pair.getValue()) instanceof ModlObject.String) {
                ModlObject.String str = (ModlObject.String)value;
                throw new NumLookupRedirect(str.string);
            }
            this.findRedirect(pair.getModlValue());
        }
        if (structure instanceof ModlObject.Map) {
            ModlObject.Map map = (ModlObject.Map)structure;
            for (ModlObject.Pair pair : map.getPairs()) {
                this.findRedirect((ModlValue)pair);
            }
        }
        if (structure instanceof ModlObject.Array) {
            ModlObject.Array array = (ModlObject.Array)structure;
            for (ModlValue modlValue : array.getModlValues()) {
                this.findRedirect(modlValue);
            }
        }
    }

    public PopulatorResponse interpretPopulatorResponse(String numRecord) throws NumBadRecordException {
        assert (numRecord != null && numRecord.trim().length() > 0);
        try {
            ModlObject modlObject = Interpreter.interpret((String)numRecord, new ArrayList());
            String configJson = JsonPrinter.printModl((ModlObject)modlObject);
            return (PopulatorResponse)this.objectMapper.readValue(configJson, PopulatorResponse.class);
        }
        catch (Exception e) {
            throw new NumBadRecordException("Error interpreting populator response record.", e);
        }
    }
}

