/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.module;

import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.util.SimpleCache;

public class ModuleFactory {
    private static final SimpleCache<String, ModuleDNSQueries> moduleMap = new SimpleCache();

    private ModuleFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleDNSQueries getInstance(String moduleName, String domainName) throws NumInvalidParameterException, NumBadURLException {
        ModuleDNSQueries result;
        if (moduleName == null || moduleName.trim().isEmpty()) {
            throw new NumInvalidParameterException("Invalid moduleName supplied: null or empty.");
        }
        if (domainName == null || domainName.trim().isEmpty()) {
            throw new NumInvalidParameterException("Invalid domainName supplied: null or empty.");
        }
        String key = moduleName + "_" + domainName;
        SimpleCache<String, ModuleDNSQueries> simpleCache = moduleMap;
        synchronized (simpleCache) {
            result = moduleMap.get(key);
            if (result == null) {
                result = new ModuleDNSQueries(moduleName, domainName);
                result.initialise();
                moduleMap.put(key, result);
            }
        }
        return result;
    }
}

