/*
 * Decompiled with CFR 0.152.
 */
package uk.num.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import uk.num.numlib.api.NumAPICallbacks;
import uk.num.numlib.api.NumAPICallbacksDefaultHandler;
import uk.num.numlib.api.NumAPIContext;
import uk.num.numlib.api.NumAPIImpl;
import uk.num.numlib.api.UserVariable;
import uk.num.numlib.dns.DNSServices;
import uk.num.numlib.exc.NumNoRecordAvailableException;

public final class NUMURLConnection
extends URLConnection {
    public static final String USE_POPULATOR = "NUM_USE_POPULATOR";
    public static final String HIDE_PARAMS = "NUM_HIDE_PARAMS";
    public static final String MODULES_LOCATION = "MODULES_LOCATION";
    public static final String RAW_RESULT = "INTERPRET_TO_JSON";
    private static DNSServices dnsServices = null;
    private NumAPIImpl numAPI = null;
    private NumAPIContext ctx = null;
    private boolean dnsSecSigned;
    private NumAPICallbacks.Location location;

    public NUMURLConnection(@NonNull URL url) {
        super(url);
        if (url == null) {
            throw new NullPointerException("url is marked @NonNull but is null");
        }
    }

    @Override
    public void setReadTimeout(int timeout) {
        super.setReadTimeout(timeout);
    }

    @Override
    public URL getURL() {
        return super.getURL();
    }

    @Override
    public int getContentLength() {
        return super.getContentLength();
    }

    @Override
    public long getContentLengthLong() {
        return super.getContentLengthLong();
    }

    @Override
    public String getContentType() {
        return super.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return super.getContentEncoding();
    }

    @Override
    public long getExpiration() {
        return super.getExpiration();
    }

    @Override
    public long getDate() {
        return super.getDate();
    }

    @Override
    public long getLastModified() {
        return super.getLastModified();
    }

    @Override
    public String getHeaderField(String name) {
        return super.getHeaderField(name);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return super.getHeaderFields();
    }

    @Override
    public int getHeaderFieldInt(String name, int Default) {
        return super.getHeaderFieldInt(name, Default);
    }

    @Override
    public long getHeaderFieldLong(String name, long Default) {
        return super.getHeaderFieldLong(name, Default);
    }

    @Override
    public long getHeaderFieldDate(String name, long Default) {
        return super.getHeaderFieldDate(name, Default);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return super.getHeaderFieldKey(n);
    }

    @Override
    public String getHeaderField(int n) {
        return super.getHeaderField(n);
    }

    @Override
    public Object getContent() throws IOException {
        return super.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return super.getContent(classes);
    }

    @Override
    public Permission getPermission() throws IOException {
        return super.getPermission();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            boolean interpret;
            boolean bl = interpret = this.getRequestProperty(RAW_RESULT) == null;
            if (!this.connected) {
                this.connect();
            }
            NumAPICallbacksDefaultHandler handler = new NumAPICallbacksDefaultHandler();
            Future<String> future = this.numAPI.retrieveNumRecord(this.ctx, handler, this.getReadTimeout(), interpret);
            String json = future.get(this.getReadTimeout(), TimeUnit.MILLISECONDS);
            this.numAPI.shutdown();
            this.connected = false;
            if (json != null) {
                this.dnsSecSigned = handler.isSignedDNSSEC();
                this.location = handler.getLocation();
                ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
                return new BufferedInputStream(stream);
            }
            throw new IOException((Throwable)new NumNoRecordAvailableException("No Record"));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return super.getOutputStream();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public boolean getDoInput() {
        return super.getDoInput();
    }

    @Override
    public void setDoInput(boolean doinput) {
        super.setDoInput(doinput);
    }

    @Override
    public boolean getDoOutput() {
        return super.getDoOutput();
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        super.setDoOutput(dooutput);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return super.getAllowUserInteraction();
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        super.setAllowUserInteraction(allowuserinteraction);
    }

    @Override
    public boolean getUseCaches() {
        return super.getUseCaches();
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        super.setUseCaches(usecaches);
    }

    @Override
    public long getIfModifiedSince() {
        return super.getIfModifiedSince();
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        super.setIfModifiedSince(ifmodifiedsince);
    }

    @Override
    public boolean getDefaultUseCaches() {
        return super.getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
        super.setDefaultUseCaches(defaultusecaches);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        super.setRequestProperty(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        super.addRequestProperty(key, value);
    }

    @Override
    public String getRequestProperty(String key) {
        return super.getRequestProperty(key);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return super.getRequestProperties();
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            try {
                this.numAPI = dnsServices != null ? new NumAPIImpl(dnsServices, null) : new NumAPIImpl();
                this.ctx = this.numAPI.begin(this.url, 1000);
                boolean hideParams = !"false".equalsIgnoreCase(this.getRequestProperty(HIDE_PARAMS));
                boolean populatorQueryRequired = "true".equalsIgnoreCase(this.getRequestProperty(USE_POPULATOR));
                String modulesLocation = this.getRequestProperty(MODULES_LOCATION);
                if (modulesLocation != null) {
                    this.numAPI.setModulesLocation(modulesLocation);
                }
                this.ctx.setPopulatorQueryRequired(populatorQueryRequired);
                String query = this.url.getQuery();
                if (StringUtils.isNotEmpty((CharSequence)query)) {
                    String[] parts = query.split("&");
                    UserVariable[] userVariables = new UserVariable[parts.length];
                    int i = 0;
                    for (String part : parts) {
                        UserVariable uv = new UserVariable();
                        String[] userVariableParts = part.split("=");
                        if (userVariableParts.length > 0) {
                            String key = hideParams ? StringUtils.prependIfMissing((String)userVariableParts[0], (CharSequence)"_", (CharSequence[])new CharSequence[0]) : userVariableParts[0];
                            uv.setKey(key);
                        }
                        if (userVariableParts.length > 1) {
                            uv.setValue(userVariableParts[1]);
                        }
                        userVariables[i] = uv;
                        ++i;
                    }
                    this.ctx.setRequiredUserVariables(userVariables);
                }
                if (this.getReadTimeout() == 0) {
                    this.setReadTimeout(60000);
                }
                this.connected = true;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static DNSServices getDnsServices() {
        return dnsServices;
    }

    public static void setDnsServices(DNSServices dnsServices) {
        NUMURLConnection.dnsServices = dnsServices;
    }

    public NumAPIContext getCtx() {
        return this.ctx;
    }

    public boolean isDnsSecSigned() {
        return this.dnsSecSigned;
    }

    public NumAPICallbacks.Location getLocation() {
        return this.location;
    }
}

