/*
 * Decompiled with CFR 0.152.
 */
package cn.openjava.basic.format.exception;

import cn.openjava.basic.format.message.IComplexMessage;
import cn.openjava.basic.format.message.IMessage;
import cn.openjava.basic.format.message.MessageType;
import java.text.MessageFormat;
import org.springframework.http.HttpStatus;

public class BaseException
extends RuntimeException {
    private final int code;
    private final String message;
    private MessageType type = MessageType.WARNING;
    private HttpStatus httpStatus = HttpStatus.OK;

    public BaseException(IMessage message, Object ... fillStr) {
        this.type = message.type();
        this.code = message.code();
        this.message = MessageFormat.format(message.message(), fillStr);
    }

    public BaseException(IComplexMessage message, Object ... fillStr) {
        this.httpStatus = message.httpStatus();
        this.type = message.type();
        this.code = message.code();
        this.message = MessageFormat.format(message.message(), fillStr);
    }

    public BaseException(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public BaseException(MessageType type, int code, String message) {
        this.type = type;
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public MessageType getType() {
        return this.type;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }
}

