/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@ESExprOverrideCodec(value=Optional.class)
public class OptionalCodec<T>
extends ESExprCodec<Optional<T>> {
    private final ESExprCodec<T> itemCodec;

    public OptionalCodec(ESExprCodec<T> itemCodec) {
        this.itemCodec = itemCodec;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull ESExprTag> tags() {
        HashSet<ESExprTag> tags = new HashSet<ESExprTag>();
        tags.add(new ESExprTag.Null());
        tags.addAll(this.itemCodec.tags());
        return tags;
    }

    @Override
    @NotNull
    public ESExpr encode(@NotNull Optional<T> value) {
        return value.map(x -> {
            ESExpr res = this.itemCodec.encode(x);
            if (!(res instanceof ESExpr.Null)) return res;
            ESExpr.Null $b$0 = (ESExpr.Null)res;
            try {
                BigInteger patt1$temp;
                BigInteger level = patt1$temp = $b$0.level();
                return new ESExpr.Null(level.add(BigInteger.ONE));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }).orElseGet(() -> new ESExpr.Null(BigInteger.ZERO));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Optional<T> decode(@NotNull ESExpr expr, @NotNull ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Null)) return Optional.of(this.itemCodec.decode(expr));
        ESExpr.Null nullVal = (ESExpr.Null)expr;
        try {
            BigInteger bigInteger;
            BigInteger level = bigInteger = nullVal.level();
            if (level.signum() != 0) return Optional.of(this.itemCodec.decode(new ESExpr.Null(level.subtract(BigInteger.ONE))));
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return Optional.empty();
    }
}

