/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.geometry.playfield;

import dev.secondsun.geometry.Model;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.geometry.Vertex;
import dev.secondsun.geometry.Vertex2D;
import dev.secondsun.geometry.playfield.MonasteryPlayfield;
import dev.secondsun.util.BSPTree;
import dev.secondsun.util.BoundedCube;
import dev.secondsun.util.Resources;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class Cube
implements Model {
    private final Resources resources;
    private final List<Triangle> tiles = new ArrayList<Triangle>();
    private int textureId1;
    private int textureId2;

    public Cube(Resources resources) {
        this(10.0f, resources);
    }

    public Cube(float scale, Resources resources) {
        Triangle[] cube;
        this.resources = resources;
        try {
            int imageID = resources.setImage(ImageIO.read(MonasteryPlayfield.class.getClassLoader().getResourceAsStream("water_texture.png")));
            this.textureId1 = resources.setTexture(imageID, new Vertex2D(0.0f, 0.0f), 1, 1);
            this.textureId2 = resources.setTexture(imageID, new Vertex2D(1.0f, 1.0f), -1, -1);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.textureId1 = Color.DARK_GRAY.getRGB();
            this.textureId2 = Color.DARK_GRAY.getRGB();
        }
        Vertex v1 = new Vertex(-scale, -scale, -scale);
        Vertex v2 = new Vertex(-scale, scale, -scale);
        Vertex v3 = new Vertex(scale, scale, -scale);
        Vertex v4 = new Vertex(scale, -scale, -scale);
        Vertex v5 = new Vertex(-scale, -scale, scale);
        Vertex v6 = new Vertex(-scale, scale, scale);
        Vertex v7 = new Vertex(scale, scale, scale);
        Vertex v8 = new Vertex(scale, -scale, scale);
        for (Triangle q : cube = new Triangle[]{new Triangle(v1, v2, v3, this.textureId1), new Triangle(v1, v3, v4, this.textureId2), new Triangle(v4, v3, v7, this.textureId1), new Triangle(v4, v7, v8, this.textureId2), new Triangle(v8, v7, v6, this.textureId1), new Triangle(v8, v6, v5, this.textureId2), new Triangle(v5, v6, v2, this.textureId1), new Triangle(v5, v2, v1, this.textureId2), new Triangle(v2, v6, v7, this.textureId1), new Triangle(v2, v7, v3, this.textureId2), new Triangle(v8, v5, v1, this.textureId1), new Triangle(v8, v1, v4, this.textureId2)}) {
            this.tiles.add(q);
        }
    }

    @Override
    public List<Triangle> getTriangles() {
        return this.tiles;
    }

    public BSPTree getBSPTree() {
        BSPTree.Node node = new BSPTree.Node();
        node.bounds = new BoundedCube(this);
        return new BSPTree(node);
    }
}

