/*
 * Decompiled with CFR 0.152.
 */
package org.osiam;

import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.osiam.auth.oauth_client.ClientEntity;
import org.osiam.auth.oauth_client.ClientRepository;
import org.osiam.resources.provisioning.SCIMUserProvisioning;
import org.osiam.resources.scim.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExampleData {
    private static final Logger logger = LoggerFactory.getLogger(ExampleData.class);
    private final ClientRepository clientRepository;
    private final SCIMUserProvisioning userProvisioning;

    @Autowired
    public ExampleData(ClientRepository clientRepository, SCIMUserProvisioning userProvisioning) {
        this.clientRepository = clientRepository;
        this.userProvisioning = userProvisioning;
    }

    @PostConstruct
    public void create() {
        if (this.clientRepository.count() == 0L) {
            ClientEntity exampleClient = new ClientEntity();
            exampleClient.setAccessTokenValiditySeconds(28800);
            exampleClient.setClientSecret("secret");
            exampleClient.setClientId("example-client");
            exampleClient.setImplicit(false);
            exampleClient.setRedirectUri("http://localhost:5000/oauth2");
            exampleClient.setRefreshTokenValiditySeconds(86400);
            exampleClient.setValidityInSeconds(28800L);
            exampleClient.setScope((Collection)Lists.newArrayList((Object[])new String[]{"ADMIN", "ME"}));
            exampleClient.setGrants((Collection)Lists.newArrayList((Object[])new String[]{"authorization_code", "refresh_token", "password", "client_credentials"}));
            this.clientRepository.saveAndFlush((Object)exampleClient);
            logger.info("Created OAuth client 'example-client' with secret 'secret'");
        }
        if (this.userProvisioning.count() == 0L) {
            User adminUser = this.userProvisioning.create(new User.Builder("admin").setActive(Boolean.valueOf(true)).setPassword("koala").build());
            logger.info("Created admin user 'admin' with password 'koala' and id '{}'", (Object)adminUser.getId());
        }
    }
}

