/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.auth.login.ldap;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osiam.auth.exception.LdapConfigurationException;
import org.osiam.auth.login.ldap.OsiamLdapUserContextMapper;
import org.osiam.resources.scim.User;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;

public class ScimToLdapAttributeMapping {
    private final Map<String, String> scimToLdapAttributes = new HashMap();

    public ScimToLdapAttributeMapping(Map<String, String> attributeMapping) {
        this.scimToLdapAttributes.putAll(attributeMapping);
        if (!this.scimToLdapAttributes.containsKey("userName")) {
            this.scimToLdapAttributes.put("userName", "uid");
        }
        this.checkMapping();
    }

    public Collection<String> ldapAttributes() {
        return this.scimToLdapAttributes.values();
    }

    public Collection<String> scimAttributes() {
        return this.scimToLdapAttributes.keySet();
    }

    public String toLdapAttribute(String scimAttribute) {
        return (String)this.scimToLdapAttributes.get(scimAttribute);
    }

    private void checkMapping() {
        DirContextAdapter ldapUserData = new DirContextAdapter();
        for (String scimAttribute : this.scimToLdapAttributes.keySet()) {
            if (scimAttribute.equalsIgnoreCase("password")) {
                throw new LdapConfigurationException("The password can not be mapped to the SCIM user. Please delete the password mapping fromthe configuration!");
            }
            ldapUserData.setAttributeValue((String)this.scimToLdapAttributes.get(scimAttribute), (Object)"test@test.de");
        }
        OsiamLdapUserContextMapper contextMapper = new OsiamLdapUserContextMapper(this);
        User user = contextMapper.mapUser((DirContextOperations)ldapUserData);
        contextMapper.mapUpdateUser(user, (DirContextOperations)ldapUserData);
    }
}

