/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.auth.oauth_client;

import java.io.IOException;
import java.util.List;
import org.osiam.auth.exception.ClientAlreadyExistsException;
import org.osiam.auth.exception.ClientNotFoundException;
import org.osiam.auth.oauth_client.ClientEntity;
import org.osiam.auth.oauth_client.ClientRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/Client"})
public class ClientManagementController {
    private final ClientRepository clientRepository;

    @Autowired
    public ClientManagementController(ClientRepository clientRepository) {
        this.clientRepository = clientRepository;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ClientEntity getClient(@PathVariable String id) {
        return this.findClientOrThrow(id);
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<ClientEntity> getClients() {
        return this.clientRepository.findAll();
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ClientEntity create(@RequestBody ClientEntity client) throws IOException {
        if (this.clientRepository.existsById(client.getClientId())) {
            throw new ClientAlreadyExistsException(String.format("The client with the id '%s' already exists", client.getClientId()));
        }
        return (ClientEntity)this.clientRepository.save((Object)client);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable String id) {
        this.clientRepository.deleteById(id);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ClientEntity update(@PathVariable String id, @RequestBody ClientEntity client) throws IOException {
        client.setInternalId(this.findClientOrThrow(id).getInternalId());
        return (ClientEntity)this.clientRepository.save((Object)client);
    }

    private ClientEntity findClientOrThrow(@PathVariable String id) {
        ClientEntity client = this.clientRepository.findById(id);
        if (client == null) {
            throw new ClientNotFoundException("Client with the id '" + id + "' not found.");
        }
        return client;
    }
}

